<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\Activite;
use App\Form\ActiviteMembreType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class ActiviteParentController extends AbstractController
{
    #[Route('/activite-parent', name: 'app_activite_parent')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
            
            
            $participantId = $request->query->get('id');
            $membre = $doctrine->getRepository(Membre::class)->findOneBy(['id' => $participantId]);
            
            $form = $this->createForm(ActiviteMembreType::class, $membre, [
                'method' => 'POST',
    
            ]);
            
            
            $form->handleRequest($request);
            
    
            if($form->isSubmitted()){

                $activiteEntities = $form->get('activite')->getData();

                $activiteIds = [];
                foreach ($activiteEntities as $activite) {
                    $activiteIds[] = $activite->getId();
                }
                
            $activites = $doctrine->getRepository(Activite::class)->findBy(['id' => $activiteIds]);
            
            foreach ($activites as $activite) {
                $membre->addActivite($activite);
                //dump($membre).die();
                
            }
            

                $entityManager->persist($membre);
                $entityManager->flush();
                $this->addFlash('success', "Ajout avec succès!");

                return $this->redirectToRoute('edit-parents', ['id' => $participantId]);
            }

        return $this->render('activite_parent/index.html.twig', [
            'form' => $form->createView(),
            'membre' =>$membre,
        ]);
    }
}
