<?php

namespace App\Controller;

use App\Entity\User;
use App\Form\RegistrationFormType;
use App\Form\UsersFormType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;

class AddUserController extends AbstractController
{
    #[Route('/add-user', name: 'app_register'), 
    IsGranted("ROLE_ADMIN")]
    
    public function register(Request $request, UserPasswordHasherInterface $userPasswordHasher, EntityManagerInterface $entityManager): Response
    {
        $user = new User();
        $form = $this->createForm(UsersFormType::class, $user);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            // encode the plain password
            //dump($form->getData()->getRole()).die();
            if ($form->getData()->getRole() == 'Cadre') {
                $user->setRoles(['ROLE_CADRE']);
            }
            elseif($form->getData()->getRole() == 'Intervenant'){
                $user->setRoles(['ROLE_INTERVENANT']);
            }
            elseif($form->getData()->getRole() == 'Intervenant Psychosocial'){
                $user->setRoles(['ROLE_INTERVENANTPSYCHOSOCIAL']);
            }
            //$user->setRoles([]);
            $user->setPassword(
                $userPasswordHasher->hashPassword(
                    $user,
                    $form->get('plainPassword')->getData()
                )
            );
            //dump($user).die();

            $entityManager->persist($user);
            $entityManager->flush();
            $this->addFlash('success', "Ajout avec succès!");
            // do anything else you need here, like send an email

            return $this->redirectToRoute('app_register');
        }

        return $this->render('registration/register.html.twig', [
            'registrationForm' => $form->createView(),
        ]);
    }
}
