<?php

namespace App\Controller;

use App\Entity\TrancheAge;
use App\Form\TrancheAgeType;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AgeController extends AbstractController
{

    #[Route('/configuration-trancheage', name: 'trancheage_configuration')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index_age(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        $age = new TrancheAge;
        $form = $this->createForm(TrancheAgeType::class, $age);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($age);

            $manager->flush();
            $this->addFlash("success","Ajout avec succès");
            return $this->redirectToRoute('trancheage_configuration');
        }
        else{
            $repository = $doctrine->getRepository(TrancheAge::class);
            $tranche_ages = $repository->findAll();
            

        }
        
            return $this->render('age/tranche_age.html.twig', [
                'tranche_ages' => $tranche_ages,
                'form' => $form->createView(),
            ]);
        

       
       
    }


    #[Route('/configuration-trancheage/editer/{id?0}', name: 'trancheage_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_age($id,TrancheAge $age=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        //$age = new TrancheAge;
        if(!$age){
            $age = new TrancheAge();

        }
        $form = $this->createForm(TrancheAgeType::class, $age);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($age);

            $manager->flush();
            //$this->addFlash($age->getTrancheage() , " a été ajouté avec succès");
            $this->addFlash('success', "Modification avec succès!");
            return $this->redirectToRoute('trancheage_configuration');
        }
        else{
            $repository = $doctrine->getRepository(TrancheAge::class);
            $tranche_ages = $repository->findAll();
            

        }
        
            return $this->render('age/tranche_age.html.twig', [
                'tranche_ages' => $tranche_ages,
                'form' => $form->createView(),
            ]);
        

       
       
    }

    #[Route('/supprimer-age/{id?0}', name: 'supprimer-age'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer tranche âge

        $trancheage = $doctrine->getRepository(TrancheAge::class)->find($id);

        if (!$trancheage) {
            throw $this->createNotFoundException('No trancheage found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($trancheage);
        $manager->flush();
        $this->addFlash('success', "Suppression avec succès!");

        return $this->redirectToRoute('trancheage_configuration');
    }
  
}
