<?php

namespace App\Controller;

use App\Entity\Activite;
use App\Entity\Programme;
use App\Form\ActiviteType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AjouterActiviteController extends AbstractController
{
    #[Route('/ajouter-activite', name: 'app_ajouter_activite')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        $activite = new Activite();
    
     
        $form = $this->createForm(ActiviteType::class, $activite, [
            'method' => 'POST',
          
        ]);
       

        $form->handleRequest($request);

       
        
        if($form->isSubmitted()){

            $programmeId = $form->get('programmeid')->getData();
            //dump($programmeId).die();
            
            
            $activite->setProgrammeid($programmeId);
            
            $entityManager->persist($activite);
            
            $entityManager->flush();
          
    
            $this->addFlash('success', 'Activité ajoutée avec succès !');
    
           
            return $this->redirectToRoute('app_ajouter_activite');
        }

        return $this->render('ajouter_activite/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
