<?php

namespace App\Controller;

use PDO;
use App\Entity\Ecole;
use App\Entity\Membre;
use App\Entity\Seance;
use App\Entity\statut;
use App\Entity\Session;
use App\Form\MembreType;
use App\Entity\Freresoeur;
use App\Entity\MembreSeance;
use App\Entity\Anneescolaire;
use App\Entity\MembreSession;
use App\Form\FreresSoeursType;
use App\Form\AnneescolaireType;
use Doctrine\ORM\Query\Parameter;
use App\Repository\MembreRepository;
use App\Repository\SeanceRepository;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
//use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;


class AjouterEnfantController extends AbstractController
{
    
    #[Route('/ajouter-enfant', name: 'add_enfants')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request, EntityManagerInterface $entityManager): Response
    
    {
        $entityManager1 = $doctrine->getManager();
        
        $membre = new Membre();
        $membre->setType("enfant");

        
       $statutEnAttente = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'Validé']);
       $membre->setStatut($statutEnAttente);

       
           
     
        $form = $this->createForm(MembreType::class, $membre, [
            'method' => 'POST',
          
        ]);
       

        $form->handleRequest($request);

        
        if($form->isSubmitted()){
            
            // Vérification de la saisie
            $nom = $membre->getNom();
            $prenom = $membre->getPrenom();
            $parentid = $membre->getParent()->getId();

            $repository = $entityManager1->getRepository(Membre::class);

            $membreExistant = $repository->findOneBy(['nom' => $nom, 'prenom' => $prenom, 'parent' => $parentid]);

            if ($membreExistant) {
                $this->addFlash('warning', 'Vous êtes déjà inscrit dans CARD!');
                return $this->redirectToRoute('add_enfants');
            }


            $entityManager1->persist($membre);
            

            $entityManager1->flush();
          
    
            $this->addFlash('success', 'Enfant ajouté avec succès !');
    
           
            return $this->redirectToRoute('add_enfants');
        }

        

        return $this->render('ajouter_enfant/ajouter_enfant.html.twig', [
            'form' => $form->createView(),
           
        ]);
    }

    
  
}

