<?php

namespace App\Controller;

use App\Entity\NomActivite;
use App\Form\NomActiviteType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;

class AjouterNomActiviteController extends AbstractController
{
    #[Route('/ajouter/nom/activite', name: 'typeactivite_configuration')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        $nomactivite = new NomActivite();
        $form = $this->createForm(NomActiviteType::class, $nomactivite);

        $form->handleRequest($request);

        

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($nomactivite);

            $manager->flush();
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('typeactivite_configuration');
        }
        else{
            $repository = $doctrine->getRepository(NomActivite::class);
            $nomactivites = $repository->findAll();
            

        }

        return $this->render('ajouter_nom_activite/index.html.twig', [
            'nomactivites' => $nomactivites,
            'form' => $form->createView(),
        ]);
    }

    #[Route('/configuration-nomactivite/editer/{id?0}', name: 'nomactivite_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_nomactivite($id,NomActivite $nomactivite=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        if(!$nomactivite){
            $nomactivite = new NomActivite();

        }
        $form = $this->createForm(NomActiviteType::class, $nomactivite);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($nomactivite);

            $manager->flush();
            $this->addFlash("success","Modification avec succès");
            return $this->redirectToRoute('typeactivite_configuration');
        }
        else{
            $repository = $doctrine->getRepository(NomActivite::class);
            $nomactivites = $repository->findAll();
            

        }
        
        return $this->render('ajouter_nom_activite/index.html.twig', [
            'nomactivites' => $nomactivites,
            'form' => $form->createView(),
        ]);

       
       
    }

    #[Route('/supprimer-nomactivite/{id?0}', name: 'supprimer-nomactivite'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer nom activite

        $nomactivite = $doctrine->getRepository(NomActivite::class)->find($id);

        if (!$nomactivite) {
            throw $this->createNotFoundException('No nomactivite found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($nomactivite);
        $manager->flush();

        return $this->redirectToRoute('typeactivite_configuration');
    }
}
