<?php

namespace App\Controller;

use PDO;
use App\Entity\Membre;
use App\Entity\statut;
use App\Form\ParentsType;
use App\Entity\MembreSeance;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AjouterParentController extends AbstractController
{
    #[Route('/add-parent', name: 'app_ajouter_parent')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        
            $entityManager = $doctrine->getManager();
            
            $membre = new Membre();
            $membre->setType("parent");
        
           $statutEnAttente = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'Validé']);
           $membre->setStatut($statutEnAttente);
            
          // $membreseance = new MembreSeance();
    
    
            $form = $this->createForm(ParentsType::class, $membre, [
                'method' => 'POST',
    
            ]);
            
            
            $form->handleRequest($request);
            
    
            if($form->isSubmitted()){

                // Vérification de la saisie
            $nom = $membre->getNom();
            $prenom = $membre->getPrenom();
            $courriel = $membre->getCourriel();

            $repository = $entityManager->getRepository(Membre::class);

            $membreExistant = $repository->findOneBy(['nom' => $nom, 'prenom' => $prenom, 'courriel' => $courriel]);

            if ($membreExistant) {
                $this->addFlash('warning', 'Vous êtes déjà inscrit dans CARD!');
                return $this->redirectToRoute('app_ajouter_parent');
            }
            
            $datenaissance = $form->get('datenaissance')->getData();
            if ($datenaissance === null) {
                $membre->setDatenaissance(null);
            } else {
                $membre->setDatenaissance($datenaissance);
            }
                $entityManager->persist($membre);


                $entityManager->flush();
              
                $this->addFlash('success', 'Parent ajouté avec succès !');
        
               
                return $this->redirectToRoute('app_ajouter_parent');
            }
    
            
    
            
        return $this->render('ajouter_parent/ajouter_parent.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    /*public function getIdSeance($membre_id){
        $dsn = 'mysql:host=127.0.0.1;port=3306;dbname=cardsDB';
            $username = 'root';
            $password = '';
            $pdo = new PDO($dsn, $username, $password);
        
            $sql = 'SELECT seance.id
                FROM seance
                INNER JOIN session ON session.id = seance.sessions_id
                INNER JOIN membre_session ON membre_session.session_id = session.id
                WHERE membre_session.membre_id = :membre_id';
        
        $stmt = $pdo->prepare($sql);
        
        $stmt->bindParam(':membre_id', $membre_id);
        
        $stmt->execute();
         $result = $stmt->fetchAll();
         return $result ? $result[0]['id'] : null;
       
        }*/
}
