<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\Activite;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AjouterParentsActiviteRapideController extends AbstractController
{
    #[Route('/ajouter/parents/activite/rapide/{id?0}', name: 'app_ajouter_parents_activite_rapide')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index($id,Activite $activite=null,ManagerRegistry $doctrine, Request $request,EntityManagerInterface $entityManager): Response
    {
        //$activiteid = $request->query->get('id');

        $activite = $doctrine->getRepository(Activite::class)->findOneBy(['id' => $id]);
        //dump($activite).die();

        if (!$activite) {
            throw $this->createNotFoundException('Activité non trouvée');
        }

        $membre =new Membre();

        $repository = $doctrine->getRepository(Membre::class);
        
        //afficher la liste des parents qui ne sont pas inscrit à cette activité;
        $query = $entityManager->createQuery('
            SELECT m
            FROM App\Entity\Membre m
            WHERE m.statut = :statut
            AND m.type = :type
            AND :activite NOT MEMBER OF m.activite
        ')
        ->setParameter('statut', '2')
        ->setParameter('type', 'parent')
        ->setParameter('activite', $activite);

        $parents = $query->getResult();

        foreach ($parents as $child) {
            $birthdate = $child->getDatenaissance();
            $child->age = $this->calculateAge($birthdate);
        }

        

        return $this->render('ajouter_parents_activite_rapide/index.html.twig', [
            'parents' =>$parents,
            'activite' => $activite,
        ]);
    }


    private function calculateAge(\DateTime $birthdate)
    {
        $today = new \DateTime();
        $age = $today->diff($birthdate);
        return $age->y;

    }


    #[Route('/ajouter/parents/activite', name: 'ajouter_parent_act')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function Ajouter_parent_activite(ManagerRegistry $doctrine, Request $request): Response
    {
        $participantId = $request->query->get('idparticipant');
        $membre = $doctrine->getRepository(Membre::class)->findOneBy(['id' => $participantId]);

        $activiteId = $request->query->get('idactivite');
        $activite = $doctrine->getRepository(Activite::class)->findOneBy(['id' => $activiteId]);

            // Vérifier si le membre est déjà inscrit à l'activité
        if ($membre->getActivite()->contains($activite)) {
            $this->addFlash('warning', "Le membre est déjà inscrit à cette activité");
            return $this->redirectToRoute('app_editer_activite', ['id' => $activite->getId()]);
        }

        $activite->addMembre($membre);
        $membre->addActivite($activite);

        $entityManager = $doctrine->getManager();
        
            $manager = $doctrine->getManager();
            $manager->persist($membre);

            $manager->flush();
            $this->addFlash('success',"Ajout avec succès");
            return $this->redirectToRoute('app_editer_activite', ['id' => $activite->getId()]);
    
        
        return $this->render('ajouter_parents_activite_rapide/index.html.twig', [
            'activite' => $activite,
        ]);

       
       
    }
}
