<?php

namespace App\Controller;

use App\Entity\Programme;
use App\Form\ProgrammeType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;

class AjouterProgrammeController extends AbstractController
{
    #[Route('/ajouter/programme', name: 'app_ajouter_programme')]
    //IsGranted("ROLE_ADMIN, ROLE_CADRE, ROLE_INTERVENANT, ROLE_INTERVENANTPSYCHOSOCIAL")]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        
        $programme = new Programme();
        

        $form = $this->createForm(ProgrammeType::class, $programme, [
            'method' => 'POST',

        ]);
        
        
        $form->handleRequest($request);
        

        if($form->isSubmitted()){
            
            $entityManager->persist($programme);
            $entityManager->flush();
          
    
            //$this->addFlash('success', 'Enfant et frères/soeurs ajoutés avec succès !');
            $this->addFlash("success"," Ajout avec succès");
           
            return $this->redirectToRoute('app_ajouter_programme');
        }
        else{

            

            $repository = $doctrine->getRepository(Programme::class);
            $programmes = $repository->findAll();
            /*foreach ($programmes as $child) {
                $trancheage = $child->getTrancheage();
                $child->trancheage = $this->$trancheage;
                
            }*/
            //$tranche_age = TrancheAge.objects.get(id=programme.trancheage_id)
            $trancheage= $programme->getTrancheage();            

        }

        return $this->render('ajouter_programme/index.html.twig', [
            'form' => $form->createView(),
            'programmes' => $programmes,
            'trancheage' => $trancheage,
            
        ]);
    }

}
