<?php

namespace App\Controller;

use App\Entity\Seance;
use App\Form\SeanceType;
use App\Entity\SeanceDetail;
use App\Form\SeanceDetailType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AjouterSeanceController extends AbstractController
{
    #[Route('/ajouter-seance', name: 'app_ajouter_seance')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        $seance = new Seance();
        
        

        $form = $this->createForm(SeanceType::class, $seance, [
            'method' => 'POST',

        ]);

        
        
        $form->handleRequest($request);
        

        if($form->isSubmitted()){
            
            $entityManager->persist($seance);
            $entityManager->flush();
          
    
            //$this->addFlash('success', 'Enfant et frères/soeurs ajoutés avec succès !');
            $this->addFlash("success"," Ajout avec succès");
           
            return $this->redirectToRoute('app_ajouter_seance');
        }

        
        return $this->render('ajouter_seance/index.html.twig', [
            'form' => $form->createView(),
            
        ]);
    }
}
