<?php

namespace App\Controller;

use App\Entity\SeanceDetail;
use App\Form\SeanceDetailType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AjouterSeanceDetailController extends AbstractController
{
    #[Route('/ajouter/seance/detail', name: 'app_ajouter_seance_detail')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        
        $seancedetail = new SeanceDetail();
        

        

        $form = $this->createForm(SeanceDetailType::class, $seancedetail, [
            'method' => 'POST',

        ]);
        
        
        $form->handleRequest($request);
        

        

        if($form->isSubmitted()){
            
            $entityManager->persist($seancedetail);
            $entityManager->flush();
          
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('app_ajouter_seance_detail');
        }

        return $this->render('ajouter_seance_detail/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
