<?php

namespace App\Controller;

use App\Entity\Session;
use App\Form\SessionType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class AjouterSessionController extends AbstractController
{
    #[Route('/ajouter/session', name: 'app_ajouter_session')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        
        $session = new Session();
        

        $form = $this->createForm(SessionType::class, $session, [
            'method' => 'POST',

        ]);
        
        
        $form->handleRequest($request);
        

        if($form->isSubmitted()){
            
            $entityManager->persist($session);
            $entityManager->flush();
          
    
            //$this->addFlash('success', 'Enfant et frères/soeurs ajoutés avec succès !');
            $this->addFlash("success"," Ajout avec succès");
           
            return $this->redirectToRoute('app_ajouter_session');
        }

        return $this->render('ajouter_session/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
