<?php

namespace App\Controller;

use App\Entity\Suivi;
use App\Entity\Membre;
use App\Form\SuiviFormType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\Exception\FileException;

class AjouterSuiviController extends AbstractController
{
    #[Route('/ajouter-suivi', name: 'app_ajouter_suivi')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request,SluggerInterface $slugger): Response
    {

        $entityManager = $doctrine->getManager();
        
        $suivi = new Suivi();


        //$participantNom = $request->query->get('participantNom');

        $participantId = $request->query->get('id');
            

            $membreid = $doctrine->getRepository(Membre::class)->findOneBy(['id' => $participantId]);
           
            
            $suivi->setNommembre($membreid);
        

        $form = $this->createForm(SuiviFormType::class, $suivi, [
            'method' => 'POST',

        ]);
        
        
        $form->handleRequest($request);
        

        if($form->isSubmitted()){
            
             /** @var UploadedFile $brochureFile */
             $brochureFile = $form->get('fichesuivi')->getData();

             if ($brochureFile) {
                $originalFilename = pathinfo($brochureFile->getClientOriginalName(), PATHINFO_FILENAME);
                // this is needed to safely include the file name as part of the URL
                $safeFilename = $slugger->slug($originalFilename);
                $newFilename = $safeFilename.'-'.uniqid().'.'.$brochureFile->guessExtension();

                // Move the file to the directory where brochures are stored
                try {
                    $brochureFile->move(
                        $this->getParameter('fichesuivi_directory'),
                        $newFilename
                    );
                } catch (FileException $e) {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochureFilename' property to store the PDF file name
                // instead of its contents
                $suivi->setFichesuivi($newFilename);
            }

            $entityManager->persist($suivi);
            $entityManager->flush();
          
    
            //$this->addFlash('success', 'Enfant et frères/soeurs ajoutés avec succès !');
    
            $this->addFlash("success"," Ajout avec succès");
            
            return $this->redirectToRoute('app_ajouter_suivi');
        }

        return $this->render('ajouter_suivi/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}

