<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\MembreSeance;
use App\Entity\SuivieEnseignement;
use App\Entity\MembreSeanceSuiviEns;
use App\Entity\Seance;
use App\Form\SuivieEnseignementAADLType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\Exception\FileException;

class AjouterSuivieAADLController extends AbstractController
{
    #[Route('/ajouter-suivie/AADL', name: 'app_ajouter_suivie_aadl')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request,SluggerInterface $slugger): Response
    {
        $entityManager = $doctrine->getManager();
            
            $AADL = new SuivieEnseignement();
            $AADL->setNomProgramme("Aide aux devoirs : AADL");
            $participantNom = $request->query->get('participantNom');
            $seanceNom = $request->query->get('seanceNom');
            //$membreseance = new MembreSeance();
            $membreSeanceSuiviEns = new MembreSeanceSuiviEns();
            $AADL->setNomEnfant($participantNom);
            $AADL->setNomSeance($seanceNom);
            $participantId = $request->query->get('id');
            
            $seanceId = $request->query->get('seanceId');

            $membreid = $doctrine->getRepository(Membre::class)->findOneBy(['id' => $participantId]);

            $seanceid = $doctrine->getRepository(Seance::class)->findOneBy(['id' => $seanceId]);
            
            
            $membreSeanceSuiviEns->setMembre($membreid);
            $membreSeanceSuiviEns->setSeance($seanceid);
            $AADL->addMembreSeanceSuiviEn($membreSeanceSuiviEns);
           
            
    
    
            $form = $this->createForm(SuivieEnseignementAADLType::class, $AADL, [
                'method' => 'POST',
    
            ]);
            
            
            $form->handleRequest($request);
            
    
            if($form->isSubmitted()){

                /** @var UploadedFile $brochureFile */
             $brochureFile = $form->get('fichesuivie')->getData();

             if ($brochureFile) {
                $originalFilename = pathinfo($brochureFile->getClientOriginalName(), PATHINFO_FILENAME);
                // this is needed to safely include the file name as part of the URL
                $safeFilename = $slugger->slug($originalFilename);
                $newFilename = $safeFilename.'-'.uniqid().'.'.$brochureFile->guessExtension();

                // Move the file to the directory where brochures are stored
                try {
                    $brochureFile->move(
                        $this->getParameter('fichesuivi_directory'),
                        $newFilename
                    );
                } catch (FileException $e) {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochureFilename' property to store the PDF file name
                // instead of its contents
                $AADL->setFichesuivie($newFilename);
            }
                
                $entityManager->persist($AADL);
                $entityManager->flush();
              
        
                //$this->addFlash('success', 'Enfant et frères/soeurs ajoutés avec succès !');
        
                $this->addFlash("success"," Ajout avec succès");
                
                return $this->redirectToRoute('app_ajouter_suivie_aadl');
            }

        return $this->render('ajouter_suivie_aadl/index.html.twig', [
             'form' => $form->createView(),
        ]);
    }
}
