<?php

namespace App\Controller;

use App\Entity\Ecole;
use App\Form\EcoleType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EcoleController extends AbstractController
{
    #[Route('/configuration-ecole', name: 'ecole_configuration')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function add_ecole(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        $ecole = new Ecole();
        $form = $this->createForm(EcoleType::class, $ecole);

        $form->handleRequest($request);

        

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($ecole);

            $manager->flush();
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('ecole_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Ecole::class);
            $ecoles = $repository->findAll();
            

        }
        
            return $this->render('ecole/ecole.html.twig', [
                'ecoles' => $ecoles,
                'form' => $form->createView(),
            ]);
        

       
    }

    #[Route('/configuration-ecole/editer/{id?0}', name: 'ecole_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_ecole($id,Ecole $ecole=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        if(!$ecole){
            $ecole = new Ecole();

        }
        $form = $this->createForm(EcoleType::class, $ecole);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($ecole);

            $manager->flush();
            $this->addFlash("success"," modifier avec succès");
            return $this->redirectToRoute('ecole_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Ecole::class);
            $ecoles = $repository->findAll();
            

        }
        
        return $this->render('ecole/ecole.html.twig', [
            'ecoles' => $ecoles,
            'form' => $form->createView(),
        ]);

       
       
    }

    #[Route('/supprimer-ecole/{id?0}', name: 'supprimer-ecole'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer ecole

        $ecole = $doctrine->getRepository(Ecole::class)->find($id);

        if (!$ecole) {
            throw $this->createNotFoundException('No ecole found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($ecole);
        $manager->flush();

        return $this->redirectToRoute('ecole_configuration');
    }
}
