<?php

namespace App\Controller;

use App\Entity\Activite;
use App\Entity\Programme;
use App\Form\ActiviteType;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EditerActiviteController extends AbstractController
{
    #[Route('/editer-activite/{id?0}', name: 'app_editer_activite')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index($id,Activite $activite=null, ManagerRegistry $doctrine, Request $request,EntityManagerInterface $entityManager3): Response
    {
        //Editer activité

        if(!$activite){
            $activite = new Activite();

        }

    
        //Trouver le nom du prg à partir de son id  pour l'afficher dans le formulaire
        $repository2 = $doctrine->getRepository(Programme::class);
        $repository = $doctrine->getRepository(Activite::class);
                    
        $programmes = $repository2->findAll();

        foreach ($programmes as $programme) {
            $programmeId = $programme->getId();

            $Activites = $repository->findOneBy(['programmeid' => $programmeId]);
                        
            $idprg = $activite->getProgrammeId();
            if ($idprg == NULL){
                $nomprg = "Cette activité n'est pas liée à aucun programme.";

            }
            else {
                $prg = $repository2->findOneBy(['id'=>$idprg]);
                $nomprg = "Nom du programme : " . $prg->getNom();
            }
                            
        }
        
        $form = $this->createForm(ActiviteType::class, $activite, [
            'method' => 'POST',
          
        ]);


        //Affichage des listes des jeunes participants dans l'activité 
        $query3 = $entityManager3->createQuery(
            'SELECT m
            FROM  App\Entity\Membre m
            JOIN m.activite a
            WHERE a.id = :id
            AND m.type = \'enfant\''
        )->setParameter('id', $id);

        $jeunesparticipants = $query3->getResult();


        //Affichage des listes des parents participants dans l'activité 
        $query4 = $entityManager3->createQuery(
            'SELECT m
            FROM  App\Entity\Membre m
            JOIN m.activite a
            WHERE a.id = :id
            AND m.type = \'parent\''
        )->setParameter('id', $id);

        $parentsparticipants = $query4->getResult();


        $form->handleRequest($request);

        if($form->isSubmitted()){

            $programmeId = $form->get('programmeid')->getData();//prends l'id du prg du formulaire
            
            $activite->setProgrammeid($programmeId); //enregistrer l'id du prg dans l'entité Activté à l'attribut idprogramme
            
            $manager = $doctrine->getManager();
            $manager->persist($activite);
            $manager->flush();

             //$this->addFlash('success',$activite->getNom()."a été éditer avec succès");
             $this->addFlash("success"," Modifier avec succès");
             return $this->redirectToRoute('app_editer_activite', ['id' => $activite->getId()]);


         }

        return $this->render('editer_activite/index.html.twig', [
            'form' => $form->createView(),
            'activite' =>$activite,
            'jeunesparticipants'=>$jeunesparticipants,
            'parentsparticipants' => $parentsparticipants,
            'nomprg' => $nomprg,
        ]);
    }

    #[Route('/supprimer-activite/{id?0}', name: 'supprimer-activite'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer activité


        $activite = $doctrine->getRepository(Activite::class)->find($id);

        if (!$activite) {
            throw $this->createNotFoundException('No activity found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($activite);
        $manager->flush();

        return $this->redirectToRoute('app_liste_activites');
    }
}
