<?php

namespace App\Controller;

use App\Entity\Ecole;
use App\Entity\Suivi;
use App\Entity\Membre;
use App\Entity\statut;
use App\Entity\Session;
use App\Entity\Activite;
use App\Form\MembreType;
use App\Entity\Programme;
use App\Entity\Freresoeur;
use App\Entity\MembreSeance;
use App\Form\MembreEditType;
use App\Entity\Anneescolaire;
use App\Entity\MembreSeanceSuiviEns;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EditerEnfantController extends AbstractController
{
    #[Route('/editer-enfant/{id?0}',name: 'edit-enfants')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editEnfant($id,Membre $membre=null, ManagerRegistry $doctrine, Request $request,EntityManagerInterface $entityManager1,EntityManagerInterface $entityManager2, EntityManagerInterface $entityManager3): Response
    {
        

        if(!$membre){
             $membre = new Membre();
 
         }
         $membre->setType("enfant");
        
        $age= $membre->getAge();


        $session = new Session();
        
        $anneescolaire = new Anneescolaire();
        
       
        $repository = $doctrine->getRepository(Suivi::class);
        $suiviindiv = $repository->findBy(['nommembre'=>$id , 'Typesuivi'=>'1']);
        //dump($suiviindiv).die();
        $repository2 = $doctrine->getRepository(Suivi::class);
        $suivipsycho = $repository2->findBy(['nommembre'=>$id , 'Typesuivi'=>'2']);

        $repository3 = $doctrine->getRepository(MembreSeanceSuiviEns::class);
        $historiqueSessions = $repository3->findBy(['membre'=>$id, 'Suivienseignement' => NULL ]);

        

        
        $query2 = $entityManager2->createQuery(
        'SELECT a
        FROM  App\Entity\Anneescolaire a
        JOIN a.membres m
        WHERE m.id = :id'
        )->setParameter('id', $id);
    
        $historiqueAnneesscolaire = $query2->getResult();

        $query3 = $entityManager3->createQuery(
            'SELECT a
            FROM  App\Entity\Activite a
            JOIN a.membres m
            WHERE m.id = :id'
        )->setParameter('id', $id);

        $historiqueActivites = $query3->getResult();



 
         $form = $this->createForm(MembreType::class, $membre,[
            'entity' => $membre
         ]);
         

         $form->handleRequest($request);
         //dump($request).die;

         if($form->isSubmitted()){

            //$anneescoalire->addNomecole($ecole);

             $manager = $doctrine->getManager();
             $manager->persist($membre);
             $manager->flush();
             $this->addFlash("success"," Modifier avec succès");
             return $this->redirectToRoute('edit-enfants', ['id' => $membre->getId()]);


         }

        return $this->render('editer_enfant/index.html.twig', [
            'form' => $form->createView(),
            'membre' =>$membre,
            'age' =>$age,
            'suiviindiv'=>$suiviindiv,
            'suivipsycho' => $suivipsycho,
            'historiqueSessions' => $historiqueSessions,
            'historiqueAnneesscolaire' => $historiqueAnneesscolaire,
            'historiqueActivites' =>   $historiqueActivites,
            'entity' => $membre
        ]);
    }


    #[Route('/supprimer-enfant/{id?0}', name: 'delete-enfants'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
{
    $enfant = $doctrine->getRepository(Membre::class)->find($id);

    if (!$enfant) {
        throw $this->createNotFoundException('No enfant found for id ' . $id);
    }

    $suivis = $enfant->getSuivis();

    $seances = $enfant->getMembreSeanceSuiviEns();

    $manager = $doctrine->getManager();

    // Suppression de toutes les `membre_seance_suivi_ens associées
    foreach ($seances as $seance) {
        $manager->remove($seance);
    }

    // Suppression de toutes les suivis associées
    foreach ($suivis as $suivi) {
        $manager->remove($suivi);
    }

    $manager->remove($enfant);
    $manager->flush();

    return $this->redirectToRoute('app_enfants');
}

   
}
