<?php

namespace App\Controller;

use App\Entity\Suivi;
use App\Entity\Membre;
use App\Form\MembreType;
use App\Form\ParentsType;
use App\Entity\MembreSeanceSuiviEns;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EditerParentController extends AbstractController
{
   
    #[Route('/editer-parent/{id?0}', name: 'edit-parents')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editParent($id,Membre $membre=null, ManagerRegistry $doctrine, Request $request,EntityManagerInterface $entityManager3): Response
    {

        if(!$membre){
             $membre = new Membre();
 
         }
         $membre->setType("parent");
 
         $age= $membre->getAge();

         $repository = $doctrine->getRepository(Suivi::class);
         $suiviindiv = $repository->findBy(['nommembre'=>$id , 'Typesuivi'=>'1']);

         $repository2 = $doctrine->getRepository(Suivi::class);
         $suivipsycho = $repository2->findBy(['nommembre'=>$id , 'Typesuivi'=>'2']);

         $repository3 = $doctrine->getRepository(MembreSeanceSuiviEns::class);
         $historiqueSessions = $repository3->findBy(['membre'=>$id ]);
 
         $repository4 = $doctrine->getRepository(Membre::class);
         $enfants = $repository4->findBy(['parent'=>$id]);

         
         $historiqueProgrammesenfants = array();

         if(count($enfants) == 0) {
            $enfants = "Aucun enfant";
        } 
        else {

            foreach ($enfants as $enfant) {

                //afficher la liste des enfants ainsi que les programmes inscit
                $idenfant = $enfant->getId();
                $repository5 = $doctrine->getRepository(MembreSeanceSuiviEns::class);
                $programmes = $repository5->findBy(['membre' => $idenfant, 'Suivienseignement' => NULL ]);


                if(count($programmes) == 0) {
                    $historiqueProgrammesenfants[$idenfant] = "Aucun programme";
                } 
                else {

                    // Stocke les programmes dans le tableau associatif
                    $historiqueProgrammesenfants[$idenfant] = array_map(function ($programme) {
                        return $programme->getSeance()->getSessions()->getProgramme()->getNom();
                    }, $programmes);
                }


                
            
            }
        }
         

         $query3 = $entityManager3->createQuery(
            'SELECT a
            FROM  App\Entity\Activite a
            JOIN a.membres m
            WHERE m.id = :id'
        )->setParameter('id', $id);

        $historiqueActivites = $query3->getResult();
 
         
 

         $form = $this->createForm(ParentsType::class, $membre,[
            'entity' => $membre
         ]);
         $form->handleRequest($request);
         if($form->isSubmitted()){
             $manager = $doctrine->getManager();
             $manager->persist($membre);
             $manager->flush();
             $this->addFlash("success"," Modifier avec succès");
             return $this->redirectToRoute('edit-parents', ['id' => $membre->getId()]);
         }

        return $this->render('editer_parent/index.html.twig', [
            'form' => $form->createView(),
            'membre' =>$membre,
            'age' =>$age,
            'suiviindiv'=>$suiviindiv,
            'suivipsycho' => $suivipsycho,
            'historiqueSessions' => $historiqueSessions,
            'historiqueActivites' =>   $historiqueActivites,
            'enfants' =>$enfants,
            'historiqueProgrammesenfants'=>$historiqueProgrammesenfants,
            'entity' => $membre
        ]);
    }

    #[Route('/supprimer-parent/{id?0}', name: 'delete-parents'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
{
    $parent = $doctrine->getRepository(Membre::class)->find($id);

    if (!$parent) {
        throw $this->createNotFoundException('No parent found for id ' . $id);
    }
    
    $suivis = $parent->getSuivis();


    $seances = $parent->getMembreSeanceSuiviEns();

    $enfants = $parent->getParents();

    $manager = $doctrine->getManager();

    // Suppression de toutes les `membre_seance_suivi_ens associées
    foreach ($seances as $seance) {
        $manager->remove($seance);
    }

    // Suppression de toutes les suivis associées
    foreach ($suivis as $suivi) {
        $manager->remove($suivi);
    }

    // Suppression de toutes les enfants associées
    foreach ($enfants as $enfant) {
        $manager->remove($enfant);
    }

    $manager->remove($parent);
    $manager->flush();

    return $this->redirectToRoute('app_liste_parents');
}

   
}
