<?php

namespace App\Controller;

use App\Entity\Session;
use App\Entity\Programme;
use App\Form\ProgrammeType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EditerProgrammeController extends AbstractController
{
    #[Route('/editer-programme/{id?0}', name: 'app_editer_programme')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(Programme $programme=null, ManagerRegistry $doctrine, Request $request): Response
    {

        if(!$programme){
            $programme = new Programme();

        }

        $trancheage= $programme->getTrancheage();

        $programmeId = $programme->getId();

        $repository = $doctrine->getRepository(Session::class);
        $sessions = $repository->findBy(['programme'=>$programmeId]);

        $form = $this->createForm(ProgrammeType::class, $programme);
        $form->handleRequest($request);
        if($form->isSubmitted()){
            $manager = $doctrine->getManager();
            $manager->persist($programme);
            $manager->flush();

            $this->addFlash("success"," Modifier avec succès");

            return $this->redirectToRoute('app_editer_programme');
        }

       
        return $this->render('editer_programme/index.html.twig', [
            'form' => $form->createView(),
            'programme' =>$programme,
            'trancheage' =>$trancheage,
            'sessions' => $sessions,
        ]);
    }

    #[Route('/supprimer-programme/{id?0}', name: 'delete-programme'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
         $programme = $doctrine->getRepository(Programme::class)->find($id);

        if (!$programme) {
            throw $this->createNotFoundException('No program found for id ' . $id);
        }

    
        $sessions = $programme->getSessions();

        $manager = $doctrine->getManager();

        // Suppression de toutes les sessions associées
        foreach ($sessions as $session) {
            $manager->remove($session);
         }
        

        // Suppression du programme
        $manager->remove($programme);
        $manager->flush();



        return $this->redirectToRoute('app_ajouter_programme');
    }



}
