<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\Seance;
use App\Entity\Session;
use App\Form\SeanceType;
use App\Entity\MembreSeance;
use App\Entity\SeanceDetail;
use App\Entity\SuivieEnseignement;
use App\Entity\MembreSeanceSuiviEns;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Validator\Constraints\NotNull;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EditerSeanceController extends AbstractController
{
    #[Route('/editer-seance/{id?0}', name: 'app_editer_seance')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(Seance $seance=null, ManagerRegistry $doctrine, Request $request, int $id,EntityManagerInterface $entityManager1): Response
    {

        if(!$seance){
            $seance = new Seance();

        }

        $idseance = $doctrine->getRepository(Seance::class)->findOneBy(['id'=>$id]);

        $heure_debut = $seance->getHeuredebut();
        $heure_fin = $seance->getHeurefin();

        $duree_obj = $heure_debut->diff($heure_fin);
    
        $duree = $duree_obj->format('%H heures %i minutes');

        //liste avant suivie
        $participants = [];
        $membreseance = $doctrine->getRepository(MembreSeanceSuiviEns::class)->findBy(['Seance'=>$id, 'Suivienseignement'=>NULL]);

        foreach ($membreseance as $membre) {
            $membres = $membre->getMembre();
            $participant= $doctrine->getRepository(Membre::class)->findOneBy((['id'=>$membres]));
            if ($participant) {
                $participants[] = $participant; 
            }
           
        }


        
            $query = $entityManager1->createQuery(
                'SELECT mss
                FROM App\Entity\MembreSeanceSuiviEns mss
                JOIN mss.Suivienseignement s
                WHERE mss.Seance = :id'
        )->setParameter('id', $id);

        $participants_presents = $query->getResult();
      
       $seance_detail= $doctrine->getRepository(SeanceDetail::class)->findBy(['seance'=>$id]);
       //dump($seance_detail).die();
       
       $datesemaine = $doctrine->getRepository(SeanceDetail::class)->findOneBy(['seance'=>$id]);
       $semainedu =$datesemaine->getdatesemaine();

        
        $programme = $seance->getSessions()->getProgramme()->getNom();
        //dump($programme).die();
        $form = $this->createForm(SeanceType::class, $seance);
        $form->handleRequest($request);
        if($form->isSubmitted()){
            $manager = $doctrine->getManager();
            $manager->persist($seance);
            $manager->flush();

            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('app_editer_seance');
        }
        return $this->render('editer_seance/index.html.twig', [
            'form' => $form->createView(),
            'duree' => $duree,
            'seance' =>$seance,
            'participants'=>$participants,
            'programme' =>$programme,
            'participants_presents'=>$participants_presents,
            'seance_detail' => $seance_detail,
            'semainedu' => $semainedu,
        ]);
    }

    #[Route('/supprimer-seance/{id?0}', name: 'delete-seance'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        $seance = $doctrine->getRepository(Seance::class)->find($id);
    
        if (!$seance) {
            throw $this->createNotFoundException('No session found for id ' . $id);
        }
        
        $seancesdetails = $seance->getDetailseance();
    
        $manager = $doctrine->getManager();
    
        // Suppression de toutes les seancesdetails associées
        foreach ($seancesdetails as $seancesdetail) {
            $manager->remove($seancesdetail);
        }
    
        $manager->remove($seance);
        $manager->flush();
    
        return $this->redirectToRoute('app_ajouter_seance');
    }


}
