<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\Seance;
use App\Entity\Session;
use App\Form\SessionType;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class EditerSessionController extends AbstractController
{
    #[Route('/editer-session/{id?0}', name: 'edit-session')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(Session $session=null, ManagerRegistry $doctrine, Request $request,int $id,EntityManagerInterface $entityManager1): Response
    {
        if(!$session){
            $session = new Session();

        }

        $sessionId = $session->getId();

        $repository = $doctrine->getRepository(Seance::class);
        $seances = $repository->findBy(['sessions'=>$sessionId]);


        $queryBuilder = $entityManager1->createQueryBuilder();
        $queryBuilder->select('mss')
             ->from('App\Entity\MembreSeanceSuiviEns', 'mss')
             ->join('mss.Seance', 'seance')
             ->join('seance.sessions', 'session')
             ->where('session.id = :sessions_id')
             ->setParameter('sessions_id', $sessionId);

        $query = $queryBuilder->getQuery();

        $particpants = $query->getResult();
        
        

        $form = $this->createForm(SessionType::class, $session);
        $form->handleRequest($request);
        if($form->isSubmitted()){
            $manager = $doctrine->getManager();
            $manager->persist($session);
            $manager->flush();
            
            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('edit-session', ['id' => $session->getId()]);
        }


        return $this->render('editer_session/index.html.twig', [
            'form' => $form->createView(),
            'session' =>$session,
            'seances' =>$seances,
            'particpants' => $particpants,
        ]);
    }

    #[Route('/supprimer-session/{id?0}', name: 'delete-session'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        $session = $doctrine->getRepository(Session::class)->find($id);
    
        if (!$session) {
            throw $this->createNotFoundException('No session found for id ' . $id);
        }
    
        $seances = $session->getSeances();
    
        $manager = $doctrine->getManager();
    
        // Suppression de toutes les seances associées
        foreach ($seances as $seance) {
            $manager->remove($seance);
        }
    
        $manager->remove($session);
        $manager->flush();
    
        return $this->redirectToRoute('app_ajouter_session');
    }
}
