<?php

namespace App\Controller;

use App\Entity\Suivi;
use App\Form\SuiviFormType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\Exception\FileException;

class EditerSuiviController extends AbstractController
{
    #[Route('/editer/suivi/{id?0}', name: 'app_editer_suivi')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index($id,Suivi $suivi=null, ManagerRegistry $doctrine, Request $request,SluggerInterface $slugger): Response
    {
        if(!$suivi){
            $suivi = new Suivi();

        }
        $fichesuivi = $suivi->getFichesuivi();



        $suiviid = $doctrine->getRepository(Suivi::class)->findOneBy(['id' => $id]);
        $membreid =$suiviid->getNomMembre();
           
            
        $suivi->setNommembre($membreid);

        $form = $this->createForm(SuiviFormType::class, $suivi);
        $form->handleRequest($request);
        if($form->isSubmitted()){

            /** @var UploadedFile $brochureFile */
            $brochureFile = $form->get('fichesuivie')->getData();

            if ($brochureFile) {
               $originalFilename = pathinfo($brochureFile->getClientOriginalName(), PATHINFO_FILENAME);
               // this is needed to safely include the file name as part of the URL
               $safeFilename = $slugger->slug($originalFilename);
               $newFilename = $safeFilename.'-'.uniqid().'.'.$brochureFile->guessExtension();

               // Move the file to the directory where brochures are stored
               try {
                   $brochureFile->move(
                       $this->getParameter('fichesuivi_directory'),
                       $newFilename
                   );
               } catch (FileException $e) {
                   // ... handle exception if something happens during file upload
               }

               // updates the 'brochureFilename' property to store the PDF file name
               // instead of its contents
               $suivi->setFichesuivi($newFilename);
           }
            
            $manager = $doctrine->getManager();
            $manager->persist($suivi);
            $manager->flush();
            
            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('app_enfants');
        }


        return $this->render('editer_suivi/index.html.twig', [
            'form' => $form->createView(),
            'fichesuivi' =>$fichesuivi,
            'suivi' =>$suivi,
        ]);
    }


#[Route('/supprimer-suivi/{id?0}', name: 'supprimer-suivi'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        $suivi = $doctrine->getRepository(Suivi::class)->find($id);

        if (!$suivi) {
            throw $this->createNotFoundException('No suivi found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($suivi);
        $manager->flush();

        return $this->redirectToRoute('app_enfants');
    }
}
