<?php

namespace App\Controller;

use App\Entity\SuivieEnseignement;
use App\Form\SuivieEnseignementAADLType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\Exception\FileException;

class EditerSuivieAADLController extends AbstractController
{
    #[Route('/editer/suivie-aadl/{id?0}', name: 'app_editer_suivie_aadl')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(SuivieEnseignement $aadl=null, ManagerRegistry $doctrine, Request $request,SluggerInterface $slugger): Response
    {

        if(!$aadl){
            $aadl = new SuivieEnseignement();

        }

        

        $form = $this->createForm(SuivieEnseignementAADLType::class, $aadl);
        $form->handleRequest($request);
        

        $fichesuivieaadl = $aadl->getFichesuivie();

        if($form->isSubmitted()){
            $manager = $doctrine->getManager();

            /** @var UploadedFile $brochureFile */
            $brochureFile = $form->get('fichesuivie')->getData();

            if ($brochureFile) {
               $originalFilename = pathinfo($brochureFile->getClientOriginalName(), PATHINFO_FILENAME);
               // this is needed to safely include the file name as part of the URL
               $safeFilename = $slugger->slug($originalFilename);
               $newFilename = $safeFilename.'-'.uniqid().'.'.$brochureFile->guessExtension();

               // Move the file to the directory where brochures are stored
               try {
                   $brochureFile->move(
                       $this->getParameter('fichesuivi_directory'),
                       $newFilename
                   );
               } catch (FileException $e) {
                   // ... handle exception if something happens during file upload
               }

               // updates the 'brochureFilename' property to store the PDF file name
               // instead of its contents
               $aadl->setFichesuivie($newFilename);
           }

            

            $manager->persist($aadl);
            $manager->flush();
            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('app_editer_suivie_aadl');
        }

        return $this->render('editer_suivie_aadl/index.html.twig', [
            'form' => $form->createView(),
            'fichesuivieaadl' => $fichesuivieaadl,
        ]);
    }
}
