<?php

namespace App\Controller;

use App\Entity\SeanceDetail;
use App\Entity\SuivieEnseignement;
use App\Form\SuivieEnseignementNDPSType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\Exception\FileException;

class EditerSuivieNDPSController extends AbstractController
{
    #[Route('/editer/suivie-ndps/{id?0}', name: 'app_editer_suivie_ndps')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(SuivieEnseignement $ndps=null, ManagerRegistry $doctrine, Request $request,SluggerInterface $slugger): Response
    {

        if(!$ndps){
            $ndps = new SuivieEnseignement();

        }
        //dump($ndps).die();

        $seanceId = $request->query->get('seanceId');

        $datesemaine = $doctrine->getRepository(SeanceDetail::class)->findOneBy(['seance'=>$seanceId]);
            $semainedu =$datesemaine->getdatesemaine();

            $datemercredi = $doctrine->getRepository(SeanceDetail::class)->findBy(['seance'=>$seanceId]);
            //dump($datemercredi).die();
            foreach ($datemercredi as $seanceDetail) {
                $mercredi = $seanceDetail->getdateseance();
                
            }
            $fichesuiviendps = $ndps->getFichesuivie();

        $form = $this->createForm(SuivieEnseignementNDPSType::class, $ndps);
        $form->handleRequest($request);
        if($form->isSubmitted()){

            /** @var UploadedFile $brochureFile */
            $brochureFile = $form->get('fichesuivie')->getData();

            if ($brochureFile) {
               $originalFilename = pathinfo($brochureFile->getClientOriginalName(), PATHINFO_FILENAME);
               // this is needed to safely include the file name as part of the URL
               $safeFilename = $slugger->slug($originalFilename);
               $newFilename = $safeFilename.'-'.uniqid().'.'.$brochureFile->guessExtension();

               // Move the file to the directory where brochures are stored
               try {
                   $brochureFile->move(
                       $this->getParameter('fichesuivi_directory'),
                       $newFilename
                   );
               } catch (FileException $e) {
                   // ... handle exception if something happens during file upload
               }

               // updates the 'brochureFilename' property to store the PDF file name
               // instead of its contents
               $ndps->setFichesuivie($newFilename);
           }
            
            $manager = $doctrine->getManager();
            $manager->persist($ndps);
            $manager->flush();
            
            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('app_liste_seances');
        }

        return $this->render('editer_suivie_ndps/index.html.twig', [
            'form' => $form->createView(),
            'semainedu' => $semainedu,
            'mercredi' => $mercredi,
            'fichesuiviendps' =>$fichesuiviendps,
        ]);
    }
}
