<?php

namespace App\Controller;

use App\Entity\Habitation;
use App\Form\HabitationType;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;



class HabitationController extends AbstractController
{
    #[Route('/configuration-habitation',name: 'habitation_configuration')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function indexHabitation(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        $habitation = new Habitation();
        $form = $this->createForm(HabitationType::class,$habitation);

        $form->handleRequest($request);

        

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($habitation);

            $manager->flush();
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('habitation_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Habitation::class);
            $habitations = $repository->findAll();
            

        }
        
            return $this->render('habitation/type_habitation.html.twig', [
                'habitations' => $habitations,
                'form' => $form->createView(),
            ]);
        

       
       
    }

    #[Route('/configuration-habitation/editer/{id?0}', name: 'habitation_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_habitation($id,Habitation $habitation=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        //$age = new TrancheAge;
        if(!$habitation){
            $habitation = new Habitation();

        }
        $form = $this->createForm(HabitationType::class, $habitation);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($habitation);

            $manager->flush();

            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('habitation_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Habitation::class);
            $habitations = $repository->findAll();
            

        }
        
        return $this->render('habitation/type_habitation.html.twig', [
            'habitations' => $habitations,
            'form' => $form->createView(),
        ]);
        
       
    }

    #[Route('/supprimer-habitation/{id?0}', name: 'supprimer-habitation'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer habitation

        $habitation = $doctrine->getRepository(Habitation::class)->find($id);

        if (!$habitation) {
            throw $this->createNotFoundException('No habitation found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($habitation);
        $manager->flush();

        return $this->redirectToRoute('habitation_configuration');
    }
}
