<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\statut;
use App\Form\MembreType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;

class InscriptionEnfantController extends AbstractController
{
    #[Route('/inscription/enfant', name: 'app_inscription_enfant')]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        $membre = new Membre();
        $membre->setType("enfant");

       $statutEnAttente = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'En attente']);
       $membre->setStatut($statutEnAttente);
        


        $form = $this->createForm(MembreType::class, $membre, [
            'method' => 'POST',

        ]);
        
        
        $form->handleRequest($request);
        

        if($form->isSubmitted()){
            
            $entityManager->persist($membre);
            $entityManager->flush();
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('app_inscription_enfant');
        }

        return $this->render('inscription_enfant/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
