<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\statut;
use App\Form\ParentsType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;

class InscriptionParentController extends AbstractController
{
    #[Route('/inscription/parent', name: 'app_inscription_parent')]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
            
        $membre = new Membre();
        $membre->setType("parent");
    
       $statutEnAttente = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'En attente']);
       $membre->setStatut($statutEnAttente);
        


        $form = $this->createForm(ParentsType::class, $membre, [
            'method' => 'POST',

        ]);
        
        
        $form->handleRequest($request);
        

        if($form->isSubmitted()){
            
            $entityManager->persist($membre);
            $entityManager->flush();
    
            $this->addFlash("success"," Ajout avec succès");
           
            return $this->redirectToRoute('app_ajouter_parent');
        }

        
        return $this->render('inscription_parent/index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
