<?php

namespace App\Controller;

use App\Entity\Langue;
use App\Form\LangueType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;


class LangueController extends AbstractController
{
    #[Route('/configuration-langue', name: 'langue_configuration')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index_langue(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        $langue = new Langue();
        $form = $this->createForm(LangueType::class, $langue);

        $form->handleRequest($request);

        

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($langue);

            $manager->flush();
            
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('langue_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Langue::class);
            $langues = $repository->findAll();
            

        }
        
            return $this->render('langue/langue_parlee.html.twig', [
                'langues' => $langues,
                'form' => $form->createView(),
            ]);
        
       
       
    }
       
    #[Route('/configuration-langue/editer/{id?0}', name: 'langue_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_langue($id,Langue $langue=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        //$age = new TrancheAge;
        if(!$langue){
            $langue = new Langue();

        }
        $form = $this->createForm(LangueType::class, $langue);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($langue);

            $manager->flush();
            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('langue_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Langue::class);
            $langues = $repository->findAll();
            

        }
        
        return $this->render('langue/langue_parlee.html.twig', [
            'langues' => $langues,
            'form' => $form->createView(),
        ]);
        

       
       
    }
  

    #[Route('/supprimer-langue/{id?0}', name: 'supprimer-langue'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer langue

        $langue = $doctrine->getRepository(Langue::class)->find($id);

        if (!$langue) {
            throw $this->createNotFoundException('No langue found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($langue);
        $manager->flush();

        return $this->redirectToRoute('langue_configuration');
    }
}


