<?php

namespace App\Controller;

use App\Entity\User;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class ListUserController extends AbstractController
{
    #[Route('/list-user', name: 'app_list_user'), 
    IsGranted("ROLE_ADMIN")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        
        $user = new User();

        $repository = $doctrine->getRepository(User::class);
        //$users = $repository->findAll();
        $users= $repository->findBy(['role' => ['Cadre' , 'Intervenant' , 'Intervenant Psychosocial']]);

        return $this->render('list_user/index.html.twig', [
            'users' => $users,
        ]);
    }
}
