<?php

namespace App\Controller;

use App\Entity\Activite;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ListeActivitesController extends AbstractController
{
    #[Route('/liste-activites', name: 'app_liste_activites')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

    
        $repository = $doctrine->getRepository(Activite::class);
        
        $activites = $repository->findAll();

    
        return $this->render('liste_activites/index.html.twig', [
            'activites' =>$activites,
        ]);
    }

    #[Route('/export-activites', name: 'export_activites')]        // la fonction exportchildren qui retourne votre tableau d'enfants
        function exportchildren(ManagerRegistry $doctrine) {
            
            $entityManager = $doctrine->getManager();
            $activites = $entityManager->getRepository(Activite::class)->findAll();

            
        
            $filename = 'liste_activites.csv';
        
            // headers du fichier CSV
            $headers = [
                'Content-Type' => 'text/csv',
                'Content-Disposition' => 'attachment; filename="' . $filename . '"',
            ];
        
            // création du fichier CSV
            $callback = function () use ($activites) {
                $output = fopen('php://output', 'w');
        
                // entêtes du tableau
                fputcsv($output, ['Nom activite','Type activite', 'Theme activite',"Objectif activite",'Impact activite','Inscription',"Tranche age"]);
        
                // lignes de données
                foreach ($activites as $activite) {
                    $nomactivite=$activite->getNomactivite();
                    fputcsv($output, [
                        $nomactivite->getNom(),
                        $activite->getTypeactivite(),
                        $activite->getThemeactivite(),
                        $activite->getObjectifactivite(),
                        $activite->getImpactactivite(),
                        $activite->getInscription(),
                        $activite->getTrancheage(),
                        

                    ]);
                }
        
                fclose($output);
            };
        
            return new StreamedResponse($callback, 200, $headers);
            
        }
}
