<?php

namespace App\Controller;

use App\Entity\Membre;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ListeEnfantsController extends AbstractController
{
    //private $doctrine;

    #[Route('/liste-enfants', name: 'app_enfants')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]

    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $membre =new Membre();

        $repository = $doctrine->getRepository(Membre::class);
        
        $enfants = $repository->findBy(['statut' => '2', 'type' => 'enfant']);

        foreach ($enfants as $child) {
            $birthdate = $child->getDatenaissance();
            $child->age = $this->calculateAge($birthdate);
        }
        

        return $this->render('liste_enfants/liste_enfants.html.twig', [
            'enfants' =>$enfants,
            
        ]);
    }

    

    private function calculateAge(\DateTime $birthdate)
    {
        $today = new \DateTime();
        $age = $today->diff($birthdate);
        return $age->y;

    }

        #[Route('/export-enfants', name: 'export_enfants')]        // la fonction exportchildren qui retourne votre tableau d'enfants
        function exportchildren(ManagerRegistry $doctrine) {
            
            $entityManager = $doctrine->getManager();
            $enfants = $entityManager->getRepository(Membre::class)->findBy(['statut' => '2', 'type' => 'enfant']);

            
            $filename = 'liste_enfants.csv';
        
            // headers du fichier CSV
            $headers = [
                'Content-Type' => 'text/csv',
                'Content-Disposition' => 'attachment; filename="' . $filename . '"',
            ];
        
            // création du fichier CSV
            $callback = function () use ($enfants) {

                $output = fopen('php://output', 'w');
        
                // entêtes du tableau
                fputcsv($output, ['Nom', 'Prenom', 'Sexe','Date de naissance',
                "Pays d'origine", 
                'Langue','Habitation','Reference','Nom intervenant','Allergie',
                'Nom parent','Prenom parent','Email parent','Telephone parent','Adresse parent']);
        
                // lignes de données
                foreach ($enfants as $enfant) {
                    $parent = $enfant->getParent();
                    fputcsv($output, [
                        $enfant->getNom(),
                        $enfant->getPrenom(),
                        $enfant->getSexe(),
                        $enfant->getDateNaissance()->format('d/m/Y'),
                        $enfant->getPaysorigine(),
                        $enfant->getLangue(),
                        $enfant->getHabitation(),
                        $enfant->getReference(),
                        $enfant->getNomintervenant(),
                        $enfant->getAllergie(),
                        $parent->getNom(),
                        $parent->getPrenom(),
                        $parent->getCourriel(),
                        $parent->getTelephone(),
                        $parent->getAdresse(),


                    ]);
                }
        
                fclose($output);
            };
        
            return new StreamedResponse($callback, 200, $headers);
            
        }
}
