<?php

namespace App\Controller;

use App\Entity\Membre;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ListeParentsController extends AbstractController
{
    #[Route('/liste-parents', name: 'app_liste_parents')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $repository = $doctrine->getRepository(Membre::class);
        
        $parents = $repository->findBy(['statut' => '2','type' => 'parent']);

        foreach ($parents as $child) {
            $birthdate = $child->getDatenaissance();
            $child->age = $this->calculateAge($birthdate);
        }

        return $this->render('liste_parents/index.html.twig', [
            'parents' => $parents,
        ]);
    }
    
    private function calculateAge(\DateTime $birthdate)
    {
        $today = new \DateTime();
        $age = $today->diff($birthdate);
        return $age->y;

    }

    #[Route('/export-parents', name: 'export_parents')]        // la fonction exportparent qui retourne votre tableau de parents
        function exportparent(ManagerRegistry $doctrine) {
            
            $entityManager = $doctrine->getManager();
            $parents = $entityManager->getRepository(Membre::class)->findBy(['statut' => '2', 'type' => 'parent']);

            
        
            $filename = 'liste_parents.csv';
        
            // headers du fichier CSV
            $headers = [
                'Content-Type' => 'text/csv',
                'Content-Disposition' => 'attachment; filename="' . $filename . '"',
            ];
        
            // création du fichier CSV
            $callback = function () use ($parents) {
                $output = fopen('php://output', 'w');
        
                // entêtes du tableau
                fputcsv($output, ['Nom', 'Prenom', 'Sexe','Date de naissance',
                "Pays d'origine",'Langue','Monoparental','Statut occupation','Emploi','Revenue familiale',
                'Nombre des enfants']);
        
                // lignes de données
                foreach ($parents as $parent) {
                    
                    fputcsv($output, [
                        $parent->getNom(),
                        $parent->getPrenom(),
                        $parent->getSexe(),
                        $parent->getDateNaissance()->format('d/m/Y'),
                        $parent->getPaysorigine(),
                        $parent->getLangue(),
                        $parent->getMonoparental(),
                        $parent->getStatutoccupation(),
                        $parent->getEmploi(),
                        $parent->getRevenuefamiliale(),
                        $parent->getNbrjeunes(),


                    ]);
                }
        
                fclose($output);
            };
        
            return new StreamedResponse($callback, 200, $headers);
            
        }
}
