<?php

namespace App\Controller;

use App\Entity\Programme;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class ListeProgrammesController extends AbstractController
{
    #[Route('/liste-programmes', name: 'app_liste_programmes')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        
        $programme = new Programme();

        $repository = $doctrine->getRepository(Programme::class);
        $programmes = $repository->findAll();

        return $this->render('liste_programmes/index.html.twig', [
            'programmes' => $programmes,
        ]);
    }

    #[Route('/export-programmes', name: 'export_programmes')]        // la fonction exportprogrammes qui retourne votre tableau des programmes
        function exportprogrammes(ManagerRegistry $doctrine) {
            
            $entityManager = $doctrine->getManager();
            $programmes = $entityManager->getRepository(Programme::class)->findAll();
            //dump($programmes).die();
            
        
            $filename = 'liste_programmes.csv';
        
            // headers du fichier CSV
            $headers = [
                'Content-Type' => 'text/csv',
                'Content-Disposition' => 'attachment; filename="' . $filename . '"',
            ];
            // création du fichier CSV
            $callback = function (/*EntityManagerInterface $entityManager1*/) use ($programmes) {
                $output = fopen('php://output', 'w');
        
                // entêtes du tableau
            fputcsv($output, ['Nom', 'Description',"Seance","Tranche d'age"]);
        
                // lignes de données
                foreach ($programmes as $programme) {
                    $trancheage = $programme->getTrancheage();
                    
                        
                    fputcsv($output, [
                        $programme->getNom(),
                        $programme->getDescription(),
                        $programme->getSeance(),
                        $trancheage->getTrancheage(),
                        

                    ]);
                }
        
                fclose($output);
            };
        
            return new StreamedResponse($callback, 200, $headers);
            
        }
}
