<?php

namespace App\Controller;

use App\Entity\Seance;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ListeSeancesController extends AbstractController
{
    #[Route('/liste-seances', name: 'app_liste_seances')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        $seance = new Seance();

        $repository = $doctrine->getRepository(Seance::class);
        $seances = $repository->findAll();

        $noms=$seance->getSessions();
        //$nomp = $seance->getSessions()->getProgramme();

        return $this->render('liste_seances/index.html.twig', [
            'seances' => $seances,
            'noms'=> $noms,
            //'nomp' => $nomp,
        ]);
    }

    #[Route('/export-seances', name: 'export_seances')]        // la fonction exportchildren qui retourne votre tableau d'enfants
        function exportchildren(ManagerRegistry $doctrine) {
            
            $entityManager = $doctrine->getManager();
            $seances = $entityManager->getRepository(Seance::class)->findAll();

            
        
            $filename = 'liste_seances.csv';
        
            // headers du fichier CSV
            $headers = [
                'Content-Type' => 'text/csv',
                'Content-Disposition' => 'attachment; filename="' . $filename . '"',
            ];
        
            // création du fichier CSV
            $callback = function () use ($seances) {
                $output = fopen('php://output', 'w');
        
                // entêtes du tableau
                fputcsv($output, ['Nom', 'Jour',"Heure debut",'Heure fin', 'Type seance','Nom session']);
        
                // lignes de données
                foreach ($seances as $seance) {
                    $session = $seance->getSessions();
                    fputcsv($output, [
                        $seance->getNom(),
                        $seance->getJour(),
                        $seance->getHeuredebut()->format('H:i'),
                        $seance->getHeurefin()->format('H:i'),
                        $seance->getTypeseance(),
                        $session->getNom(),
                        

                    ]);
                }
        
                fclose($output);
            };
        
            return new StreamedResponse($callback, 200, $headers);
            
        }
}
