<?php

namespace App\Controller;

use App\Entity\Session;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ListeSessionController extends AbstractController
{
    #[Route('/liste-session', name: 'app_liste_session')] 
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE') or is_granted('ROLE_INTERVENANT') or is_granted('ROLE_INTERVENANTPSYCHOSOCIAL')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        $session = new Session();

        $repository = $doctrine->getRepository(Session::class);
        $sessions = $repository->findAll();

        $nom=$session->getProgramme();

        return $this->render('liste_session/index.html.twig', [
            'sessions' => $sessions,
            'nom'=> $nom,
        ]);
    }

    #[Route('/export-sessions', name: 'export_sessions')]        // la fonction exportsession qui retourne votre tableau des sessions
        function exportsession(ManagerRegistry $doctrine) {
            
            $entityManager = $doctrine->getManager();
            $sessions = $entityManager->getRepository(Session::class)->findAll();

            
        
            $filename = 'liste_sessions.csv';
        
            // headers du fichier CSV
            $headers = [
                'Content-Type' => 'text/csv',
                'Content-Disposition' => 'attachment; filename="' . $filename . '"',
            ];
        
            // création du fichier CSV
            $callback = function () use ($sessions) {
                $output = fopen('php://output', 'w');
        
                // entêtes du tableau
            fputcsv($output, ['Nom', 'Description',"Date debut",'Date fin', 'Nombre max participants',"Programme"]);
        
                // lignes de données
                foreach ($sessions as $session) {
                    $programme=$session->getProgramme();
                    fputcsv($output, [
                        $session->getNom(),
                        $session->getDescription(),
                        $session->getDatedebut()->format('d/m/Y'),
                        $session->getDatefin()->format('d/m/Y'),
                        $session->getNbrmaxparticipants(),
                        $programme->getNom(),

                    ]);
                }
        
                fclose($output);
            };
        
            return new StreamedResponse($callback, 200, $headers);
            
        }
}
