<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Form\MembreSeanceSuivType;
use App\Entity\MembreSeanceSuiviEns;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class MembreSuiviSeanceController extends AbstractController
{
    #[Route('/membre-suivi-seance-enfant', name: 'app_membre_suivi_seance')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        
            
            $membreseancesuivie = new MembreSeanceSuiviEns();
            $participantId = $request->query->get('id');
            $membreid = $doctrine->getRepository(Membre::class)->findOneBy(['id' => $participantId]);

            $membreseancesuivie->setMembre($membreid);
            $age= $membreid->getAge();

            $form = $this->createForm(MembreSeanceSuivType::class, $membreseancesuivie, [
                'method' => 'POST',
    
            ]);

            
            
            
            $form->handleRequest($request);
            
    
            if($form->isSubmitted()){

                $entityManager->persist($membreseancesuivie);
                $entityManager->flush();
                $this->addFlash("success"," Ajout avec succès");

                return $this->redirectToRoute('edit-enfants', ['id' => $participantId]);
            }

        return $this->render('membre_suivi_seance/index.html.twig', [
            'form' => $form->createView(),
            'membreid'=> $membreid,
            'age' => $age,
        ]);
    }

    #[Route('/membre-suivi-seance-parent', name: 'app_membre_suivi_seance_parent')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function ajoutersuivieparent(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
            
            $membreseancesuivie = new MembreSeanceSuiviEns();
            $participantId = $request->query->get('id');
            $membreid = $doctrine->getRepository(Membre::class)->findOneBy(['id' => $participantId]);
            $membreseancesuivie->setMembre($membreid);
            $age= $membreid->getAge();

            $form = $this->createForm(MembreSeanceSuivType::class, $membreseancesuivie, [
                'method' => 'POST',
    
            ]);
            
            

            $form->handleRequest($request);
            
            //dump($form->getData()).die();

            if($form->isSubmitted()){

                $entityManager->persist($membreseancesuivie);
                $entityManager->flush();
                $this->addFlash("success"," Ajout avec succès");

                return $this->redirectToRoute('edit-parents', ['id' => $participantId]);
            }

        return $this->render('membre_suivi_seance/index.html.twig', [
            'form' => $form->createView(),
            'membreid'=> $membreid,
            'age' => $age,
        ]);
    }
}
