<?php

namespace App\Controller;

use App\Entity\Organisme;
use App\Form\OrganismeType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class OrganismeController extends AbstractController
{ 
    #[Route('/configuration-organisme', name: 'organisme_configuration')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function config_organisme(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        $organisme = new Organisme();
        $form = $this->createForm(OrganismeType::class, $organisme);

        $form->handleRequest($request);

        

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($organisme);

            $manager->flush();
            
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('organisme_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Organisme::class);
            $organismes = $repository->findAll();
            

        }
        
            return $this->render('organisme/organisme.html.twig', [
                'organismes' => $organismes,
                'form' => $form->createView(),
            ]);
        

       
    }

    #[Route('/configuration-organisme/editer/{id?0}', name: 'organisme_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_organisme($id,Organisme $organisme=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        if(!$organisme){
            $organisme = new Organisme();

        }
        $form = $this->createForm(OrganismeType::class, $organisme);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($organisme);

            $manager->flush();
            //$this->addFlash($age->getTrancheage() , " a été ajouté avec succès");
            $this->addFlash("success"," Modifier avec succès");
            return $this->redirectToRoute('organisme_configuration');
        }
        else{
            $repository = $doctrine->getRepository(Organisme::class);
            $organismes = $repository->findAll();
            

        }
        
        return $this->render('organisme/organisme.html.twig', [
            'organismes' => $organismes,
            'form' => $form->createView(),
        ]);

       
       
    }

    #[Route('/supprimer-organisme/{id?0}', name: 'supprimer-organisme'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer organisme

        $organisme = $doctrine->getRepository(Organisme::class)->find($id);

        if (!$organisme) {
            throw $this->createNotFoundException('No organisme found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($organisme);
        $manager->flush();

        return $this->redirectToRoute('organisme_configuration');
    }
  
}
