<?php

namespace App\Controller;

use App\Entity\Projet;
use App\Form\ProjetType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;

class ProjetController extends AbstractController
{
    #[Route('/configuration-projet', name: 'app_projet')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function add_projet(ManagerRegistry $doctrine, Request $request): Response
    {
        $entityManager = $doctrine->getManager();
        $projet = new Projet();
        $form = $this->createForm(ProjetType::class, $projet);

        $form->handleRequest($request);

        

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($projet);

            $manager->flush();
            $this->addFlash("success"," Ajout avec succès");
            return $this->redirectToRoute('app_projet');
        }
        else{
            $repository = $doctrine->getRepository(Projet::class);
            $projets = $repository->findAll();
            

        }
        
        return $this->render('projet/index.html.twig', [
            'projets' => $projets,
            'form' => $form->createView(),
        ]);
        

    }

    #[Route('/configuration-projet/editer/{id?0}', name: 'projet_editer')]
    #[Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_CADRE')")]
    public function editer_projet($id,Projet $projet=null,ManagerRegistry $doctrine, Request $request): Response
    {

        $entityManager = $doctrine->getManager();
        
        if(!$projet){
            $projet = new Projet();

        }
        $form = $this->createForm(ProjetType::class, $projet);

        $form->handleRequest($request);

        if($form->isSubmitted()){
        
            $manager = $doctrine->getManager();
            $manager->persist($projet);

            $manager->flush();
            $this->addFlash("success"," modifier avec succès");
            return $this->redirectToRoute('app_projet');
        }
        else{
            $repository = $doctrine->getRepository(Projet::class);
            $projets = $repository->findAll();
            

        }
        
        return $this->render('projet/index.html.twig', [
            'projets' => $projets,
            'form' => $form->createView(),
        ]);

       
       
    }

    #[Route('/supprimer-projet/{id?0}', name: 'supprimer-projet'), 
    IsGranted("ROLE_ADMIN")]
    public function delete($id, ManagerRegistry $doctrine,Request $request): Response
    {
        //Supprimer projet

        $projet = $doctrine->getRepository(Projet::class)->find($id);

        if (!$projet) {
            throw $this->createNotFoundException('No projet found for id ' . $id);
        }
        $manager = $doctrine->getManager();

        $manager->remove($projet);
        $manager->flush();

        return $this->redirectToRoute('app_projet');
    }
}
