<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\Session;
use App\Form\MembreType;
use App\Entity\MembreSeanceSuiviEns;
use DateTime;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Finder\Exception\AccessDeniedException;

class ReinscriptionController extends AbstractController
{
    #[Route('/reinscription/{token}/{id}', name: 'app_reinscription' , methods:['GET', 'POST'])]
    public function index(string $token, Membre $membre,$id, ManagerRegistry $doctrine, Request $request): Response 
    {

        if($membre->getTokenreinscription() !== $token){
            throw new AccessDeniedException();
        }

        if($membre->getTokenreinscription() === null){
            throw new AccessDeniedException();
        }

        if(new DateTime('now') > $membre->getTokenreinscriptionlifetime()){
            throw new AccessDeniedException();
        }

        

        if(!$membre){
            $membre = new Membre();

        }
        
        $membre->setType("enfant");
       
       $age= $membre->getAge();
       $membre->setTokenreinscription(null);


       $session = new Session();
       
      
       

       $repository3 = $doctrine->getRepository(MembreSeanceSuiviEns::class);
       $historiqueSessions = $repository3->findBy(['membre'=>$id, 'Suivienseignement' => NULL ]);

       

        $form = $this->createForm(MembreType::class, $membre);
        

        $form->handleRequest($request);

        if($form->isSubmitted()){


            $manager = $doctrine->getManager();
            $manager->persist($membre);
            $manager->flush();
            $this->addFlash("success"," Succès de ReInscription!");
            return $this->redirectToRoute('app_login');


        }
        
        return $this->render('reinscription/index.html.twig', [
            'form' => $form->createView(),
            'membre' =>$membre,
            'age' =>$age,
            'historiqueSessions' => $historiqueSessions,
            
        ]);
    }
    
}
