<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Service\MailerService;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Security\Csrf\TokenGenerator\TokenGeneratorInterface;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;
use DateInterval;
use DateTime;

class SendLinkController extends AbstractController
{
    #[Route('/send/link', name: 'app_send_link')]
    public function index(MailerService $mailerService,
    TokenGeneratorInterface $tokenGeneratorInterface,
    Request $request,
    EntityManagerInterface $entityManager,
    ManagerRegistry $doctrine
    ): Response
    {

        $membre = new Membre();

        $membres = $entityManager->getRepository(Membre::class)->findBy(['type' => 'enfant']);
        

        foreach ($membres as $membre) {
            //generer un token
            $tokenreinscription = $tokenGeneratorInterface->generateToken();

        
            $membre->setTokenreinscription($tokenreinscription);

            //token expired duration
            $tokenreinscriptionlifetime = (new DateTime('now'))->add(new DateInterval("P1D"));
            $membre->setTokenreinscriptionlifetime($tokenreinscriptionlifetime);
            
            //dump($test).die();

            //dump($membre->getParent()->getId()).die();
            $idparent = $membre->getParent()->getId();
            $parents =  $entityManager->getRepository(Membre::class)->findBy(['type' => 'parent', 'id'=>$idparent]);
            //dump($parents).die();
            foreach($parents as $parent){

                    $mailerService->send(
                        $parent->getCourriel(),
                        'Réinscription',
                        'reinscription.html.twig',
                        [
                            'membre'=> $membre,
                            'token'=> $tokenreinscription,
                            'lifeTimeToken'=> $tokenreinscriptionlifetime->format('d-m-Y-H-i-s'),
                            
                        ]
                        


                    );

                    $manager = $doctrine->getManager();
                    $manager->persist($membre);
                    $manager->flush();

                    $this->addFlash("success","Emails envoyés avec succès!");
            }

        }





        return $this->render('send_link/index.html.twig', [
            'controller_name' => 'SendLinkController',
        ]);
    }
}
