<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\statut;
use App\Form\MembreType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class StatutController extends AbstractController
{
    //afficher tableau
    #[Route('/statut', name: 'app_statut'), 
    IsGranted("ROLE_ADMIN")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {

        $repository = $doctrine->getRepository(Membre::class);
        
       // $enfants = $repository->findBy(['statut' => '3']);
        $enfants = $repository->findBy(['type' => 'enfant','statut' => '1']);

        foreach ($enfants as $child) {
            $birthdate = $child->getDatenaissance();
            $child->age = $this->calculateAge($birthdate);
        }

        return $this->render('statutEnfant/index.html.twig', [
            'enfants' =>$enfants,
        ]);
    }

    

    private function calculateAge(\DateTime $birthdate)
    {
        $today = new \DateTime();
        $age = $today->diff($birthdate);
        return $age->y;

    }

    
    #[Route('/accepter/{id}', name: 'accepter_inscription'), 
    IsGranted("ROLE_ADMIN")]

    public function accepterInscription(ManagerRegistry $doctrine, Request $request)
    {
        $membre = new Membre();
        $statut = new statut();
        //$statut->setLibelle("Validé");
        $statutvalide = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'Validé']);
        $membre->setStatut($statutvalide);

        //$membre->setStatut($statut);

        $manager = $doctrine->getManager();
        $manager->persist($membre);
        $manager->flush();

        //$this->getDoctrine()->getManager()->flush();

        return $this->redirectToRoute('app_statut');
    }

   //details
    #[Route('/detail-enfant/{id?0}',name: 'detail-enfant'),
    IsGranted("ROLE_ADMIN")]
    public function editEnfant(Membre $membre=null, ManagerRegistry $doctrine, Request $request): Response
    {

        if(!$membre){
             $membre = new Membre();
 
         }
         $membre->setType("enfant");
 
         $form = $this->createForm(MembreType::class, $membre);
         $form->handleRequest($request);
         /*if($form->isSubmitted()){
             $manager = $doctrine->getManager();
             $manager->persist($membre);
             $manager->flush();
             $this->addFlash('success',$membre->getNom()."a été éditer avec succès");
             return $this->redirectToRoute('detail-enfant');
         }*/

        return $this->render('statutEnfant/valider.html.twig', [
            'form' => $form->createView(),
            'membre' =>$membre,
        ]);
       
    }


    //validation
    #[Route('/validation/{id?0}',name: 'validation-inscription'),
    IsGranted("ROLE_ADMIN")]
    public function validation(Membre $membre=null, ManagerRegistry $doctrine, Request $request)
    {
        if(!$membre){
            $membre = new Membre();

        }
        $statutValide = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'Validé']);
        $membre->setStatut($statutValide);

        $manager = $doctrine->getManager();
        $manager->persist($membre);
        $manager->flush();
        return $this->redirectToRoute('app_statut', array(
            'id' => $membre->getId()
        ));
    
    }

}
