<?php

namespace App\Controller;

use App\Entity\Membre;
use App\Entity\statut;
use App\Form\ParentsType;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class StatutparentController extends AbstractController
{
    //afficher tableau
    #[Route('/statutparent', name: 'app_statutparent'),
    IsGranted("ROLE_ADMIN")]
    public function index(ManagerRegistry $doctrine, Request $request): Response
    {
        $repository = $doctrine->getRepository(Membre::class);
        
       // $enfants = $repository->findBy(['statut' => '3']);
        $parents = $repository->findBy(['type' => 'parent','statut' => '1']);

        foreach ($parents as $child) {
            $birthdate = $child->getDatenaissance();
            $child->age = $this->calculateAge($birthdate);
        }

        return $this->render('statutparent/index.html.twig', [
            'parents' =>$parents,
        ]);
    }


    private function calculateAge(\DateTime $birthdate)
    {
        $today = new \DateTime();
        $age = $today->diff($birthdate);
        return $age->y;

    }

    
    #[Route('/accepter/{id}', name: 'accepter_inscription'),
    IsGranted("ROLE_ADMIN")]
    public function accepterInscription(ManagerRegistry $doctrine, Request $request)
    {
        $membre = new Membre();
        $statut = new statut();
        //$statut->setLibelle("Validé");
        $statutvalide = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'Validé']);
        $membre->setStatut($statutvalide);

        //$membre->setStatut($statut);

        $manager = $doctrine->getManager();
        $manager->persist($membre);
        $manager->flush();

        //$this->getDoctrine()->getManager()->flush();

        return $this->redirectToRoute('app_statutparent');
    }

   //details
    #[Route('/detail-parent/{id?0}',name: 'detail-parent'),
    IsGranted("ROLE_ADMIN")]
    public function editParent(Membre $membre=null, ManagerRegistry $doctrine, Request $request): Response
    {

        if(!$membre){
             $membre = new Membre();
 
         }
         $membre->setType("parent");
 
         $form = $this->createForm(ParentsType::class, $membre);
         $form->handleRequest($request);
         /*if($form->isSubmitted()){
             $manager = $doctrine->getManager();
             $manager->persist($membre);
             $manager->flush();
             $this->addFlash('success',$membre->getNom()."a été éditer avec succès");
             return $this->redirectToRoute('detail-enfant');
         }*/

        return $this->render('statutParent/valider.html.twig', [
            'form' => $form->createView(),
            'membre' =>$membre,
        ]);
       
    }


    //validation
    #[Route('/validation/{id?0}',name: 'validation-inscription'),
    IsGranted("ROLE_ADMIN")]
    public function validation(Membre $membre=null, ManagerRegistry $doctrine, Request $request)
    {
        if(!$membre){
            $membre = new Membre();

        }
        $statutValide = $doctrine->getRepository(statut::class)->findOneBy(['libelle' => 'Validé']);
        $membre->setStatut($statutValide);

        $manager = $doctrine->getManager();
        $manager->persist($membre);
        $manager->flush();
        return $this->redirectToRoute('app_statutparent', array(
            'id' => $membre->getId()
        ));
    
    }

}
