<?php

namespace App\Entity;

use App\Repository\ActiviteRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ActiviteRepository::class)]
class Activite
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $Typeactivite = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $themeactivite = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $objectifactivite = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $impactactivite = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $programmeid = null;

    #[ORM\ManyToMany(targetEntity: Membre::class, mappedBy: 'activite', cascade:["persist"])]
    private Collection $membres;

    #[ORM\ManyToOne(inversedBy: 'activites')]
    private ?NomActivite $nomactivite = null;

    #[ORM\Column(length: 255)]
    private ?string $inscription = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $trancheage = null;


    public function __construct()
    {
        $this->membres = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTypeactivite(): ?string
    {
        return $this->Typeactivite;
    }

    public function setTypeactivite(string $Typeactivite): self
    {
        $this->Typeactivite = $Typeactivite;

        return $this;
    }

    

    public function getThemeactivite(): ?string
    {
        return $this->themeactivite;
    }

    public function setThemeactivite(?string $themeactivite): self
    {
        $this->themeactivite = $themeactivite;

        return $this;
    }

    public function getObjectifactivite(): ?string
    {
        return $this->objectifactivite;
    }

    public function setObjectifactivite(?string $objectifactivite): self
    {
        $this->objectifactivite = $objectifactivite;

        return $this;
    }

    public function getImpactactivite(): ?string
    {
        return $this->impactactivite;
    }

    public function setImpactactivite(?string $impactactivite): self
    {
        $this->impactactivite = $impactactivite;

        return $this;
    }

    public function getProgrammeid(): ?string
    {
        return $this->programmeid;
    }

    public function setProgrammeid(?string $programmeid): self
    {
        $this->programmeid = $programmeid;

        return $this;
    }

    /**
     * @return Collection<int, Membre>
     */
    public function getMembres(): Collection
    {
        return $this->membres;
    }

    public function addMembre(Membre $membre): self
    {
        if (!$this->membres->contains($membre)) {
            $this->membres->add($membre);
            $membre->addActivite($this);
        }

        return $this;
    }

    public function removeMembre(Membre $membre): self
    {
        if ($this->membres->removeElement($membre)) {
            $membre->removeActivite($this);
        }

        return $this;
    }

    public function getNomactivite(): ?NomActivite
    {
        return $this->nomactivite;
    }

    public function setNomactivite(?NomActivite $nomactivite): self
    {
        $this->nomactivite = $nomactivite;

        return $this;
    }

    public function getInscription(): ?string
    {
        return $this->inscription;
    }

    public function setInscription(string $inscription): self
    {
        $this->inscription = $inscription;

        return $this;
    }

    public function getTrancheage(): ?string
    {
        return $this->trancheage;
    }

    public function setTrancheage(?string $trancheage): self
    {
        $this->trancheage = $trancheage;

        return $this;
    }

    
}
