<?php

namespace App\Entity;

use App\Repository\AnneescolaireRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: AnneescolaireRepository::class)]
class Anneescolaire
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $anneescolaire = null;

    /*#[ORM\Column(length: 255)]
    private ?string $nomecole = null;*/

    #[ORM\Column(length: 255)]
    private ?string $nomenseignant = null;

    #[ORM\Column(length: 255)]
    private ?string $emailenseignant = null;

    #[ORM\Column(length: 255)]
    private ?string $niveauscolaire = null;

    #[ORM\ManyToMany(targetEntity: Membre::class, mappedBy: 'AnneesScolaires', cascade:["persist"])]
    private Collection $membres;

    #[ORM\ManyToOne(inversedBy: 'anneescolaires')]
    private ?Ecole $nomecole = null;

    /*#[ORM\ManyToMany(targetEntity: Ecole::class, inversedBy: 'anneescolaires')]
    private Collection $nomecole;*/

    /*#[ORM\ManyToMany(targetEntity: Ecole::class, inversedBy: 'anneescolaires', cascade:["persist"])]
    private Collection $nomecole;*/

    public function __construct()
    {
        $this->membres = new ArrayCollection();
        //$this->nomecole = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAnneescolaire(): ?string
    {
        return $this->anneescolaire;
    }

    public function setAnneescolaire(string $anneescolaire): self
    {
        $this->anneescolaire = $anneescolaire;

        return $this;
    }

    /*public function getNomecole(): ?string
    {
        return $this->nomecole;
    }

    public function setNomecole(string $nomecole): self
    {
        $this->nomecole = $nomecole;

        return $this;
    }*/

    public function getNomenseignant(): ?string
    {
        return $this->nomenseignant;
    }

    public function setNomenseignant(string $nomenseignant): self
    {
        $this->nomenseignant = $nomenseignant;

        return $this;
    }

    public function getEmailenseignant(): ?string
    {
        return $this->emailenseignant;
    }

    public function setEmailenseignant(string $emailenseignant): self
    {
        $this->emailenseignant = $emailenseignant;

        return $this;
    }

    public function getNiveauscolaire(): ?string
    {
        return $this->niveauscolaire;
    }

    public function setNiveauscolaire(string $niveauscolaire): self
    {
        $this->niveauscolaire = $niveauscolaire;

        return $this;
    }

    /**
     * @return Collection<int, Membre>
     */
    public function getMembres(): Collection
    {
        return $this->membres;
    }

    public function addMembre(Membre $membre): self
    {
        if (!$this->membres->contains($membre)) {
            $this->membres->add($membre);
            $membre->addAnneesScolaire($this);
        }

        return $this;
    }

    public function removeMembre(Membre $membre): self
    {
        if ($this->membres->removeElement($membre)) {
            $membre->removeAnneesScolaire($this);
        }

        return $this;
    }

    /*/**
     * @return Collection<int, Ecole>
     */
   /* public function getNomecole(): Collection
    {
        return $this->nomecole;
    }*/

    /*public function addNomecole(Ecole $nomecole): self
    {
        if (!$this->nomecole->contains($nomecole)) {
            $this->nomecole->add($nomecole);
        }

        return $this;
    }

    public function removeNomecole(Ecole $nomecole): self
    {
        $this->nomecole->removeElement($nomecole);

        return $this;
    }*/

    public function getNomecole(): ?Ecole
    {
        return $this->nomecole;
    }

    public function setNomecole(?Ecole $nomecole): self
    {
        $this->nomecole = $nomecole;

        return $this;
    }

    
}
