<?php

namespace App\Entity;

use App\Repository\EcoleRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: EcoleRepository::class)]
class Ecole
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $nom = null;

    #[ORM\OneToMany(mappedBy: 'nomecole', targetEntity: Anneescolaire::class)]
    private Collection $anneescolaires;

    public function __construct()
    {
        $this->anneescolaires = new ArrayCollection();
    }

   

    /*#[ORM\ManyToMany(targetEntity: Anneescolaire::class, mappedBy: 'nomecole')]
    private Collection $anneescolaires;*/

    /*public function __construct()
    {
        $this->anneescolaires = new ArrayCollection();
    }*/

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): self
    {
        $this->nom = $nom;

        return $this;
    }
    public function __toString(): string
    {
        return $this->getNom();

    }

    /*/**
     * @return Collection<int, Anneescolaire>
     */
   /* public function getAnneescolaires(): Collection
    {
        return $this->anneescolaires;
    }

    public function addAnneescolaire(Anneescolaire $anneescolaire): self
    {
        if (!$this->anneescolaires->contains($anneescolaire)) {
            $this->anneescolaires->add($anneescolaire);
            $anneescolaire->addNomecole($this);
        }

        return $this;
    }

    public function removeAnneescolaire(Anneescolaire $anneescolaire): self
    {
        if ($this->anneescolaires->removeElement($anneescolaire)) {
            $anneescolaire->removeNomecole($this);
        }

        return $this;
    }*/

   /**
    * @return Collection<int, Anneescolaire>
    */
   public function getAnneescolaires(): Collection
   {
       return $this->anneescolaires;
   }

   public function addAnneescolaire(Anneescolaire $anneescolaire): self
   {
       if (!$this->anneescolaires->contains($anneescolaire)) {
           $this->anneescolaires->add($anneescolaire);
           $anneescolaire->setNomecole($this);
       }

       return $this;
   }

   public function removeAnneescolaire(Anneescolaire $anneescolaire): self
   {
       if ($this->anneescolaires->removeElement($anneescolaire)) {
           // set the owning side to null (unless already changed)
           if ($anneescolaire->getNomecole() === $this) {
               $anneescolaire->setNomecole(null);
           }
       }

       return $this;
   }

   
}
