<?php

namespace App\Entity;

use App\Repository\MembreRepository;
use DateInterval;
use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints\Date;

#[ORM\Entity(repositoryClass: MembreRepository::class)]
#[ORM\HasLifecycleCallbacks()]
class Membre
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $nom = null;

    #[ORM\Column(length: 255)]
    private ?string $prenom = null;


    #[ORM\Column(length: 255)]
    private ?string $sexe = null;

    #[ORM\Column(length: 255)]
    private ?string $paysorigine = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $allergie = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomintervenant = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $emailparent = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $telparent = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $adresseparent = null;

    #[ORM\Column(nullable: true)]
    private ?int $nbrfrsr = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $type = null;


    #[ORM\ManyToOne(inversedBy: 'membres')]
    private ?Langue $Langue = null;

    #[ORM\ManyToOne(inversedBy: 'membres')]
    private ?Habitation $habitation = null;

    #[ORM\ManyToOne(inversedBy: 'membres')]
    private ?Organisme $reference = null;

    #[ORM\ManyToMany(targetEntity: Anneescolaire::class, inversedBy: 'membres', cascade:["persist"])]
    private Collection $AnneesScolaires;

    #[ORM\OneToMany(mappedBy: 'membre',targetEntity: Freresoeur::class, cascade:["persist"])]
    private Collection $FreresSoeurs;


    #[ORM\ManyToOne(inversedBy: 'membres')]
    #[ORM\JoinColumn(nullable: false)]
    private ?statut $statut = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $courriel = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $telephone = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $adresse = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $monoparental = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $statutoccupation = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $revenuefamiliale = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nbrjeunes = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomparent = null;

    #[ORM\ManyToOne(targetEntity: self::class, inversedBy: 'parents')]
    private ?self $parent = null;

    #[ORM\OneToMany(mappedBy: 'parent', targetEntity: self::class)]
    private Collection $parents;


    #[ORM\OneToMany(mappedBy: 'nommembre', targetEntity: Suivi::class)]
    private Collection $suivis;

    #[ORM\OneToMany(mappedBy: 'membre', targetEntity: MembreSeanceSuiviEns::class)]
    private Collection $membreSeanceSuiviEns;

    #[ORM\ManyToMany(targetEntity: Activite::class, inversedBy: 'membres', cascade:["persist"])]
    private Collection $activite;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $tokenreinscription = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $tokenreinscriptionlifetime = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $Emploi = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datenaissance = null;

    #[ORM\ManyToMany(targetEntity: Projet::class, inversedBy: 'membres')]
    private Collection $projet;


  
    public function __construct()
    {
        $this->AnneesScolaires = new ArrayCollection();
        $this->FreresSoeurs = new ArrayCollection();
        $this->parents = new ArrayCollection();
        $this->suivis = new ArrayCollection();
        $this->membreSeanceSuiviEns = new ArrayCollection();
        $this->activite = new ArrayCollection();
        $this->tokenreinscriptionlifetime = (new DateTime('now'))->add(new DateInterval("P1D"));
        $this->projet = new ArrayCollection();
        
    }


   


    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): self
    {
        $this->nom = $nom;

        return $this;
    }

    public function getPrenom(): ?string
    {
        return $this->prenom;
    }

    public function setPrenom(string $prenom): self
    {
        $this->prenom = $prenom;

        return $this;
    }

   
  
    public function getSexe(): ?string
    {
        return $this->sexe;
    }

    public function setSexe(string $sexe): self
    {
        $this->sexe = $sexe;

        return $this;
    }

    public function getPaysorigine(): ?string
    {
        return $this->paysorigine;
    }

    public function setPaysorigine(string $paysorigine): self
    {
        $this->paysorigine = $paysorigine;

        return $this;
    }

 

    public function getAllergie(): ?string
    {
        return $this->allergie;
    }

    public function setAllergie(?string $allergie): self
    {
        $this->allergie = $allergie;

        return $this;
    }

    

    public function getNomintervenant(): ?string
    {
        return $this->nomintervenant;
    }

    public function setNomintervenant(?string $nomintervenant): self
    {
        $this->nomintervenant = $nomintervenant;

        return $this;
    }

    

   

    public function getEmailparent(): ?string
    {
        return $this->emailparent;
    }

    public function setEmailparent(?string $emailparent): self
    {
        $this->emailparent = $emailparent;

        return $this;
    }

    public function getTelparent(): ?string
    {
        return $this->telparent;
    }

    public function setTelparent(?string $telparent): self
    {
        $this->telparent = $telparent;

        return $this;
    }

    public function getAdresseparent(): ?string
    {
        return $this->adresseparent;
    }

    public function setAdresseparent(?string $adresseparent): self
    {
        $this->adresseparent = $adresseparent;

        return $this;
    }

    public function getNbrfrsr(): ?int
    {
        return $this->nbrfrsr;
    }

    public function setNbrfrsr(?int $nbrfrsr): self
    {
        $this->nbrfrsr = $nbrfrsr;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function __toString(): string
    {
        return $this->getType();
        return $this->getDatenaissance();
       

    }


    public function getLangue(): ?Langue
    {
        return $this->Langue;
    }

    public function setLangue(?Langue $Langue): self
    {
        $this->Langue = $Langue;

        return $this;
    }

   

   public function getHabitation(): ?Habitation
   {
       return $this->habitation;
   }

   public function setHabitation(?Habitation $habitation): self
   {
       $this->habitation = $habitation;

       return $this;
   }

   public function getReference(): ?Organisme
   {
       return $this->reference;
   }

   public function setReference(?Organisme $reference): self
   {
       $this->reference = $reference;

       return $this;
   }

   /**
    * @return Collection<int, Anneescolaire>
    */
   public function getAnneesScolaires(): Collection
   {
       return $this->AnneesScolaires;
   }

   public function addAnneesScolaire(Anneescolaire $anneesScolaire): self
   {
       if (!$this->AnneesScolaires->contains($anneesScolaire)) {
           $this->AnneesScolaires->add($anneesScolaire);
       }

       return $this;
   }

   public function removeAnneesScolaire(Anneescolaire $anneesScolaire): self
   {
       $this->AnneesScolaires->removeElement($anneesScolaire);

       return $this;
   }

   /**
    * @return Collection<int, Freresoeur>
    */
   public function getFreresSoeurs(): Collection
   {
       return $this->FreresSoeurs;
   }

   public function addFreresSoeur(Freresoeur $freresSoeur): self
   {
       if (!$this->FreresSoeurs->contains($freresSoeur)) {
        //$this->FreresSoeurs[] = $freresSoeur;
           $this->FreresSoeurs->add($freresSoeur);
           $freresSoeur->setMembre($this);
       }

       return $this;
   }

   public function removeFreresSoeur(Freresoeur $freresSoeur): self
   {
       if ($this->FreresSoeurs->removeElement($freresSoeur)) {
           // set the owning side to null (unless already changed)
           if ($freresSoeur->getMembre() === $this) {
               $freresSoeur->setMembre(null);
           }
       }

       return $this;
   }

   public function getStatut(): ?statut
   {
       return $this->statut;
   }

   public function setStatut(?statut $statut): self
   {
       $this->statut = $statut;

       return $this;
   }

   public function getCourriel(): ?string
   {
       return $this->courriel;
   }

   public function setCourriel(?string $courriel): self
   {
       $this->courriel = $courriel;

       return $this;
   }

   public function getTelephone(): ?string
   {
       return $this->telephone;
   }

   public function setTelephone(?string $telephone): self
   {
       $this->telephone = $telephone;

       return $this;
   }

   public function getAdresse(): ?string
   {
       return $this->adresse;
   }

   public function setAdresse(?string $adresse): self
   {
       $this->adresse = $adresse;

       return $this;
   }

   public function getMonoparental(): ?string
   {
       return $this->monoparental;
   }

   public function setMonoparental(?string $monoparental): self
   {
       $this->monoparental = $monoparental;

       return $this;
   }

   public function getStatutoccupation(): ?string
   {
       return $this->statutoccupation;
   }

   public function setStatutoccupation(?string $statutoccupation): self
   {
       $this->statutoccupation = $statutoccupation;

       return $this;
   }

   public function getRevenuefamiliale(): ?string
   {
       return $this->revenuefamiliale;
   }

   public function setRevenuefamiliale(?string $revenuefamiliale): self
   {
       $this->revenuefamiliale = $revenuefamiliale;

       return $this;
   }

   public function getNbrjeunes(): ?string
   {
       return $this->nbrjeunes;
   }

   public function setNbrjeunes(?string $nbrjeunes): self
   {
       $this->nbrjeunes = $nbrjeunes;

       return $this;
   }

   

   public function getAge(): ?int
   {
       $dateOfBirth = $this->getDatenaissance();
       if ($dateOfBirth === null) {
           return null;
       }

       $today = new DateTime();
       $interval = $today->diff($dateOfBirth);

       return $interval->y;
   }

  
  
   public function getNomparent(): ?string
   {
       return $this->nomparent;
   }

   public function setNomparent(?string $nomparent): self
   {
       $this->nomparent = $nomparent;

       return $this;
   }

   public function getParent(): ?self
   {
       return $this->parent;
   }

   public function setParent(?self $parent): self
   {
       $this->parent = $parent;

       return $this;
   }

   /**
    * @return Collection<int, self>
    */
   public function getParents(): Collection
   {
       return $this->parents;
   }

   public function addParent(self $parent): self
   {
       if (!$this->parents->contains($parent)) {
           $this->parents->add($parent);
           $parent->setParent($this);
       }

       return $this;
   }

   public function removeParent(self $parent): self
   {
       if ($this->parents->removeElement($parent)) {
           // set the owning side to null (unless already changed)
           if ($parent->getParent() === $this) {
               $parent->setParent(null);
           }
       }

       return $this;
   }

 
   /**
    * @return Collection<int, Suivi>
    */
   public function getSuivis(): Collection
   {
       return $this->suivis;
   }

   public function addSuivi(Suivi $suivi): self
   {
       if (!$this->suivis->contains($suivi)) {
           $this->suivis->add($suivi);
           $suivi->setNommembre($this);
       }

       return $this;
   }

   public function removeSuivi(Suivi $suivi): self
   {
       if ($this->suivis->removeElement($suivi)) {
           // set the owning side to null (unless already changed)
           if ($suivi->getNommembre() === $this) {
               $suivi->setNommembre(null);
           }
       }

       return $this;
   }

   /**
    * @return Collection<int, MembreSeanceSuiviEns>
    */
   public function getMembreSeanceSuiviEns(): Collection
   {
       return $this->membreSeanceSuiviEns;
   }

   public function addMembreSeanceSuiviEn(MembreSeanceSuiviEns $membreSeanceSuiviEn): self
   {
       if (!$this->membreSeanceSuiviEns->contains($membreSeanceSuiviEn)) {
           $this->membreSeanceSuiviEns->add($membreSeanceSuiviEn);
           $membreSeanceSuiviEn->setMembre($this);
       }

       return $this;
   }

   public function removeMembreSeanceSuiviEn(MembreSeanceSuiviEns $membreSeanceSuiviEn): self
   {
       if ($this->membreSeanceSuiviEns->removeElement($membreSeanceSuiviEn)) {
           // set the owning side to null (unless already changed)
           if ($membreSeanceSuiviEn->getMembre() === $this) {
               $membreSeanceSuiviEn->setMembre(null);
           }
       }

       return $this;
   }

   /**
    * @return Collection<int, Activite>
    */
   public function getActivite(): Collection
   {
       return $this->activite;
   }

   public function addActivite(Activite $activite): self
   {
       if (!$this->activite->contains($activite)) {
           $this->activite->add($activite);
       }

       return $this;
   }

   public function removeActivite(Activite $activite): self
   {
       $this->activite->removeElement($activite);

       return $this;
   }

  

   public function getTokenreinscription(): ?string
   {
       return $this->tokenreinscription;
   }

   public function setTokenreinscription(?string $tokenreinscription): self
   {
       $this->tokenreinscription = $tokenreinscription;

       return $this;
   }

   public function getTokenreinscriptionlifetime(): ?\DateTimeInterface
   {
       return $this->tokenreinscriptionlifetime;
   }

   public function setTokenreinscriptionlifetime(?\DateTimeInterface $tokenreinscriptionlifetime): self
   {
       $this->tokenreinscriptionlifetime = $tokenreinscriptionlifetime;

       return $this;
   }

   public function getEmploi(): ?string
   {
       return $this->Emploi;
   }

   public function setEmploi(?string $Emploi): self
   {
       $this->Emploi = $Emploi;

       return $this;
   }

   public function getDatenaissance(): ?\DateTimeInterface
   {
       return $this->datenaissance;
   }

   public function setDatenaissance(?\DateTimeInterface $datenaissance): self
   {
       $this->datenaissance = $datenaissance;

       return $this;
   }

   

   /**
    * @return Collection<int, Projet>
    */
   public function getProjet(): Collection
   {
       return $this->projet;
   }

   public function addProjet(Projet $projet): self
   {
       if (!$this->projet->contains($projet)) {
           $this->projet->add($projet);
       }

       return $this;
   }

   public function removeProjet(Projet $projet): self
   {
       $this->projet->removeElement($projet);

       return $this;
   }
  
    
}
