<?php

namespace App\Entity;

use App\Repository\ProgrammeRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ProgrammeRepository::class)]
class Programme
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $nom = null;


    #[ORM\Column(length: 255, nullable: true)]
    private ?string $description = null;

   

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $seance = null;

    #[ORM\ManyToOne(inversedBy: 'programmes')]
    private ?TrancheAge $trancheage = null;

    #[ORM\OneToMany(mappedBy: 'programme', targetEntity: Session::class)]
    private Collection $sessions;

    public function __construct()
    {
        $this->sessions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): self
    {
        $this->nom = $nom;

        return $this;
    }

  

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

  

    public function getSeance(): ?string
    {
        return $this->seance;
    }

    public function setSeance(?string $seance): self
    {
        $this->seance = $seance;

        return $this;
    }

    public function getTrancheage(): ?TrancheAge
    {
        return $this->trancheage;
    }

    public function setTrancheage(?TrancheAge $trancheage): self
    {
        $this->trancheage = $trancheage;

        return $this;
    }

    /**
     * @return Collection<int, Session>
     */
    public function getSessions(): Collection
    {
        return $this->sessions;
    }

    public function addSession(Session $session): self
    {
        if (!$this->sessions->contains($session)) {
            $this->sessions->add($session);
            $session->setProgramme($this);
        }

        return $this;
    }

    public function removeSession(Session $session): self
    {
        if ($this->sessions->removeElement($session)) {
            // set the owning side to null (unless already changed)
            if ($session->getProgramme() === $this) {
                $session->setProgramme(null);
            }
        }

        return $this;
    }
}
