<?php

namespace App\Entity;

use App\Repository\SeanceRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SeanceRepository::class)]
class Seance
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $nom = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $jour = null;

    #[ORM\Column(type: Types::TIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $heuredebut = null;

    #[ORM\Column(type: Types::TIME_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $heurefin = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $typeseance = null;

    #[ORM\ManyToOne(inversedBy: 'seances')]
    private ?Session $sessions = null;

    #[ORM\OneToMany(mappedBy: 'seance', targetEntity: SeanceDetail::class)]
    private Collection $detailseance;

    #[ORM\Column(type: Types::ARRAY, nullable: true)]
    private $semainendps = [];

    #[ORM\OneToMany(mappedBy: 'Seance', targetEntity: MembreSeanceSuiviEns::class)]
    private Collection $membreSeanceSuiviEns;


    public function __construct()
    {
        $this->detailseance = new ArrayCollection();
        $this->semainendps = [];
        $this->membreSeanceSuiviEns = new ArrayCollection();
    }

   
    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): self
    {
        $this->nom = $nom;

        return $this;
    }

    public function getJour(): ?string
    {
        return $this->jour;
    }

    public function setJour(?string $jour): self
    {
        $this->jour = $jour;

        return $this;
    }

    public function getHeuredebut(): ?\DateTimeInterface
    {
        return $this->heuredebut;
    }

    public function setHeuredebut(?\DateTimeInterface $heuredebut): self
    {
        $this->heuredebut = $heuredebut;

        return $this;
    }

    public function getHeurefin(): ?\DateTimeInterface
    {
        return $this->heurefin;
    }

    public function setHeurefin(?\DateTimeInterface $heurefin): self
    {
        $this->heurefin = $heurefin;

        return $this;
    }

    public function getTypeseance(): ?string
    {
        return $this->typeseance;
    }

    public function setTypeseance(?string $typeseance): self
    {
        $this->typeseance = $typeseance;

        return $this;
    }

    public function getSessions(): ?Session
    {
        return $this->sessions;
    }

    public function setSessions(?Session $sessions): self
    {
        $this->sessions = $sessions;

        return $this;
    }

    

    /**
     * @return Collection<int, SeanceDetail>
     */
    public function getDetailseance(): Collection
    {
        return $this->detailseance;
    }

    public function addDetailseance(SeanceDetail $detailseance): self
    {
        if (!$this->detailseance->contains($detailseance)) {
            $this->detailseance->add($detailseance);
            $detailseance->setSeance($this);
        }

        return $this;
    }

    public function removeDetailseance(SeanceDetail $detailseance): self
    {
        if ($this->detailseance->removeElement($detailseance)) {
            // set the owning side to null (unless already changed)
            if ($detailseance->getSeance() === $this) {
                $detailseance->setSeance(null);
            }
        }

        return $this;
    }

    public function getSemainendps(): ?array
    {
        return $this->semainendps;
    }

    public function setSemainendps(?array $semainendps): self
    {
        $this->semainendps = $semainendps;

        return $this;
    }

    /**
     * @return Collection<int, MembreSeanceSuiviEns>
     */
    public function getMembreSeanceSuiviEns(): Collection
    {
        return $this->membreSeanceSuiviEns;
    }

    public function addMembreSeanceSuiviEn(MembreSeanceSuiviEns $membreSeanceSuiviEn): self
    {
        if (!$this->membreSeanceSuiviEns->contains($membreSeanceSuiviEn)) {
            $this->membreSeanceSuiviEns->add($membreSeanceSuiviEn);
            $membreSeanceSuiviEn->setSeance($this);
        }

        return $this;
    }

    public function removeMembreSeanceSuiviEn(MembreSeanceSuiviEns $membreSeanceSuiviEn): self
    {
        if ($this->membreSeanceSuiviEns->removeElement($membreSeanceSuiviEn)) {
            // set the owning side to null (unless already changed)
            if ($membreSeanceSuiviEn->getSeance() === $this) {
                $membreSeanceSuiviEn->setSeance(null);
            }
        }

        return $this;
    }

   

    
}
