<?php

namespace App\Entity;

use App\Repository\SuiviRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SuiviRepository::class)]
class Suivi
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::DATE_MUTABLE)]
    private ?\DateTimeInterface $Dateintervention = null;

    #[ORM\Column(nullable: true)]
    private ?\DateInterval $dureeintervention = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $raison = null;

    #[ORM\ManyToOne(inversedBy: 'suivis')]
    private ?Membre $nommembre = null;



    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $note = null;


    #[ORM\ManyToOne(inversedBy: 'suivis')]
    private ?TypeSuivi $Typesuivi = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $fichesuivi = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $suivipar = null;

    #[ORM\ManyToOne(inversedBy: 'suivis')]
    private ?User $intervenant = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateintervention(): ?\DateTimeInterface
    {
        return $this->Dateintervention;
    }

    public function setDateintervention(\DateTimeInterface $Dateintervention): self
    {
        $this->Dateintervention = $Dateintervention;

        return $this;
    }

    public function getDureeintervention(): ?\DateInterval
    {
        return $this->dureeintervention;
    }

    public function setDureeintervention(?\DateInterval $dureeintervention): self
    {
        $this->dureeintervention = $dureeintervention;

        return $this;
    }

    public function getRaison(): ?string
    {
        return $this->raison;
    }

    public function setRaison(?string $raison): self
    {
        $this->raison = $raison;

        return $this;
    }

    public function getNommembre(): ?Membre
    {
        return $this->nommembre;
    }

    public function setNommembre(?Membre $nommembre): self
    {
        $this->nommembre = $nommembre;

        return $this;
    }

    

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    

    public function getTypesuivi(): ?TypeSuivi
    {
        return $this->Typesuivi;
    }

    public function setTypesuivi(?TypeSuivi $Typesuivi): self
    {
        $this->Typesuivi = $Typesuivi;

        return $this;
    }

    public function getFichesuivi(): ?string
    {
        return $this->fichesuivi;
    }

    public function setFichesuivi(?string $fichesuivi): self
    {
        $this->fichesuivi = $fichesuivi;

        return $this;
    }

    public function getSuivipar(): ?string
    {
        return $this->suivipar;
    }

    public function setSuivipar(?string $suivipar): self
    {
        $this->suivipar = $suivipar;

        return $this;
    }

    public function getIntervenant(): ?User
    {
        return $this->intervenant;
    }

    public function setIntervenant(?User $intervenant): self
    {
        $this->intervenant = $intervenant;

        return $this;
    }
}
