<?php

namespace App\Entity;

use App\Repository\SuivieEnseignementRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SuivieEnseignementRepository::class)]
class SuivieEnseignement
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::DATE_MUTABLE, nullable: true)]
    private ?\DateTimeInterface $datesuivie = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomprogramme = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $presence = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomseance = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $matiere = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomenfant = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nomtuteur = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $travail = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $descriptiontravail = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $comportement = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $commentaireintervenant = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $commentaireenseignant = null;

    #[ORM\Column(nullable: true)]
    private ?int $nbreactivites = null;



    #[ORM\Column(length: 255, nullable: true)]
    private ?string $presenceseance1 = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $presenceseance2 = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $commentaireintervenant2 = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $commentaireenseignant2 = null;

    #[ORM\Column(nullable: true)]
    private ?int $nbreactivites2 = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $fichesuivie = null;

    #[ORM\OneToMany(mappedBy: 'Suivienseignement', targetEntity: MembreSeanceSuiviEns::class, cascade: ['persist', 'remove'])]
    private Collection $membreSeanceSuiviEns;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $thematique = null;

    public function __construct()
    {
        $this->membreSeanceSuiviEns = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateSuivie(): ?\DateTimeInterface
    {
        return $this->datesuivie;
    }

    public function setDateSuivie(?\DateTimeInterface $datesuivie): self
    {
        $this->datesuivie = $datesuivie;

        return $this;
    }

    public function getNomProgramme(): ?string
    {
        return $this->nomprogramme;
    }

    public function setNomProgramme(?string $nomprogramme): self
    {
        $this->nomprogramme = $nomprogramme;

        return $this;
    }

    public function getPresence(): ?string
    {
        return $this->presence;
    }

    public function setPresence(?string $presence): self
    {
        $this->presence = $presence;

        return $this;
    }

    public function getNomSeance(): ?string
    {
        return $this->nomseance;
    }

    public function setNomSeance(?string $nomseance): self
    {
        $this->nomseance = $nomseance;

        return $this;
    }

    public function getMatiere(): ?string
    {
        return $this->matiere;
    }

    public function setMatiere(?string $matiere): self
    {
        $this->matiere = $matiere;

        return $this;
    }

    public function getNomEnfant(): ?string
    {
        return $this->nomenfant;
    }

    public function setNomEnfant(?string $nomenfant): self
    {
        $this->nomenfant = $nomenfant;

        return $this;
    }

    public function getNomTuteur(): ?string
    {
        return $this->nomtuteur;
    }

    public function setNomTuteur(?string $nomtuteur): self
    {
        $this->nomtuteur = $nomtuteur;

        return $this;
    }

    public function getTravail(): ?string
    {
        return $this->travail;
    }

    public function setTravail(?string $travail): self
    {
        $this->travail = $travail;

        return $this;
    }

    public function getDescriptiontravail(): ?string
    {
        return $this->descriptiontravail;
    }

    public function setDescriptiontravail(?string $descriptiontravail): self
    {
        $this->descriptiontravail = $descriptiontravail;

        return $this;
    }

    public function getComportement(): ?string
    {
        return $this->comportement;
    }

    public function setComportement(?string $comportement): self
    {
        $this->comportement = $comportement;

        return $this;
    }

    public function getCommentaireintervenant(): ?string
    {
        return $this->commentaireintervenant;
    }

    public function setCommentaireintervenant(?string $commentaireintervenant): self
    {
        $this->commentaireintervenant = $commentaireintervenant;

        return $this;
    }

    public function getCommentaireenseignant(): ?string
    {
        return $this->commentaireenseignant;
    }

    public function setCommentaireenseignant(?string $commentaireenseignant): self
    {
        $this->commentaireenseignant = $commentaireenseignant;

        return $this;
    }

    public function getNbreactivites(): ?int
    {
        return $this->nbreactivites;
    }

    public function setNbreactivites(?int $nbreactivites): self
    {
        $this->nbreactivites = $nbreactivites;

        return $this;
    }

    /*public function getFichesuivie()
    {
        return $this->fichesuivie;
    }

    public function setFichesuivie($fichesuivie): self
    {
        $this->fichesuivie = $fichesuivie;

        return $this;
    }*/

    /*public function getMembreSeance(): ?MembreSeance
    {
        return $this->membreSeance;
    }

    public function setMembreSeance(?MembreSeance $membreSeance): self
    {
        // unset the owning side of the relation if necessary
        if ($membreSeance === null && $this->membreSeance !== null) {
            $this->membreSeance->setSuivieenseignement(null);
        }

        // set the owning side of the relation if necessary
        if ($membreSeance !== null && $membreSeance->getSuivieenseignement() !== $this) {
            $membreSeance->setSuivieenseignement($this);
        }

        $this->membreSeance = $membreSeance;

        return $this;
    }*/

    public function getPresenceSeance1(): ?string
    {
        return $this->presenceseance1;
    }

    public function setPresenceSeance1(?string $presenceseance1): self
    {
        $this->presenceseance1 = $presenceseance1;

        return $this;
    }

    public function getPresenceSeance2(): ?string
    {
        return $this->presenceseance2;
    }

    public function setPresenceSeance2(?string $presenceseance2): self
    {
        $this->presenceseance2 = $presenceseance2;

        return $this;
    }

    public function getCommentaireintervenant2(): ?string
    {
        return $this->commentaireintervenant2;
    }

    public function setCommentaireintervenant2(?string $commentaireintervenant2): self
    {
        $this->commentaireintervenant2 = $commentaireintervenant2;

        return $this;
    }

    public function getCommentaireenseignant2(): ?string
    {
        return $this->commentaireenseignant2;
    }

    public function setCommentaireenseignant2(?string $commentaireenseignant2): self
    {
        $this->commentaireenseignant2 = $commentaireenseignant2;

        return $this;
    }

    public function getNbreactivites2(): ?int
    {
        return $this->nbreactivites2;
    }

    public function setNbreactivites2(?int $nbreactivites2): self
    {
        $this->nbreactivites2 = $nbreactivites2;

        return $this;
    }

    public function getFichesuivie(): ?string
    {
        return $this->fichesuivie;
    }

    public function setFichesuivie(?string $fichesuivie): self
    {
        $this->fichesuivie = $fichesuivie;

        return $this;
    }

    /**
     * @return Collection<int, MembreSeanceSuiviEns>
     */
    public function getMembreSeanceSuiviEns(): Collection
    {
        return $this->membreSeanceSuiviEns;
    }

    public function addMembreSeanceSuiviEn(MembreSeanceSuiviEns $membreSeanceSuiviEn): self
    {
        if (!$this->membreSeanceSuiviEns->contains($membreSeanceSuiviEn)) {
            $this->membreSeanceSuiviEns->add($membreSeanceSuiviEn);
            $membreSeanceSuiviEn->setSuivienseignement($this);
        }

        return $this;
    }

    public function removeMembreSeanceSuiviEn(MembreSeanceSuiviEns $membreSeanceSuiviEn): self
    {
        if ($this->membreSeanceSuiviEns->removeElement($membreSeanceSuiviEn)) {
            // set the owning side to null (unless already changed)
            if ($membreSeanceSuiviEn->getSuivienseignement() === $this) {
                $membreSeanceSuiviEn->setSuivienseignement(null);
            }
        }

        return $this;
    }

    public function getThematique(): ?string
    {
        return $this->thematique;
    }

    public function setThematique(?string $thematique): self
    {
        $this->thematique = $thematique;

        return $this;
    }
}
